/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

class InstanceDiscoveryMetadataEntry {
    @SerializedName(value="preferred_network")
    String preferredNetwork;
    @SerializedName(value="preferred_cache")
    String preferredCache;
    @SerializedName(value="aliases")
    Set<String> aliases;

    InstanceDiscoveryMetadataEntry(String preferredNetwork, String preferredCache, Set<String> aliases) {
        this.preferredNetwork = preferredNetwork;
        this.preferredCache = preferredCache;
        this.aliases = aliases;
    }

    public static InstanceDiscoveryMetadataEntryBuilder builder() {
        return new InstanceDiscoveryMetadataEntryBuilder();
    }

    String preferredNetwork() {
        return this.preferredNetwork;
    }

    String preferredCache() {
        return this.preferredCache;
    }

    Set<String> aliases() {
        return this.aliases;
    }

    public static class InstanceDiscoveryMetadataEntryBuilder {
        private String preferredNetwork;
        private String preferredCache;
        private Set<String> aliases;

        public InstanceDiscoveryMetadataEntryBuilder aliases(String[] aliasesArray) {
            TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (aliasesArray != null) {
                set.addAll(Arrays.asList(aliasesArray));
            }
            this.aliases = Collections.unmodifiableSet(set);
            return this;
        }

        InstanceDiscoveryMetadataEntryBuilder() {
        }

        public InstanceDiscoveryMetadataEntryBuilder preferredNetwork(String preferredNetwork) {
            this.preferredNetwork = preferredNetwork;
            return this;
        }

        public InstanceDiscoveryMetadataEntryBuilder preferredCache(String preferredCache) {
            this.preferredCache = preferredCache;
            return this;
        }

        public InstanceDiscoveryMetadataEntry build() {
            return new InstanceDiscoveryMetadataEntry(this.preferredNetwork, this.preferredCache, this.aliases);
        }

        public String toString() {
            return "InstanceDiscoveryMetadataEntry.InstanceDiscoveryMetadataEntryBuilder(preferredNetwork=" + this.preferredNetwork + ", preferredCache=" + this.preferredCache + ", aliases=" + this.aliases + ")";
        }
    }
}

