/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.DeviceCode;
import com.microsoft.aad.msal4j.IApiParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;

public class DeviceCodeFlowParameters
implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private Consumer<DeviceCode> deviceCodeConsumer;

    private static DeviceCodeFlowParametersBuilder builder() {
        return new DeviceCodeFlowParametersBuilder();
    }

    public static DeviceCodeFlowParametersBuilder builder(Set<String> scopes, Consumer<DeviceCode> deviceCodeConsumer) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        return DeviceCodeFlowParameters.builder().scopes(scopes).deviceCodeConsumer(deviceCodeConsumer);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public Consumer<DeviceCode> deviceCodeConsumer() {
        return this.deviceCodeConsumer;
    }

    private DeviceCodeFlowParameters(@NonNull Set<String> scopes, @NonNull Consumer<DeviceCode> deviceCodeConsumer) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (deviceCodeConsumer == null) {
            throw new NullPointerException("deviceCodeConsumer is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.deviceCodeConsumer = deviceCodeConsumer;
    }

    public static class DeviceCodeFlowParametersBuilder {
        private Set<String> scopes;
        private Consumer<DeviceCode> deviceCodeConsumer;

        DeviceCodeFlowParametersBuilder() {
        }

        public DeviceCodeFlowParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public DeviceCodeFlowParametersBuilder deviceCodeConsumer(Consumer<DeviceCode> deviceCodeConsumer) {
            this.deviceCodeConsumer = deviceCodeConsumer;
            return this;
        }

        public DeviceCodeFlowParameters build() {
            return new DeviceCodeFlowParameters(this.scopes, this.deviceCodeConsumer);
        }

        public String toString() {
            return "DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder(scopes=" + this.scopes + ", deviceCodeConsumer=" + this.deviceCodeConsumer + ")";
        }
    }
}

