/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.KeyCredential;
import com.microsoft.graph.models.extensions.PasswordCredential;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.ApplicationAddKeyRequest;
import com.microsoft.graph.requests.extensions.IApplicationAddKeyRequest;
import com.microsoft.graph.requests.extensions.IApplicationAddKeyRequestBuilder;
import java.util.List;

public class ApplicationAddKeyRequestBuilder
extends BaseActionRequestBuilder
implements IApplicationAddKeyRequestBuilder {
    public ApplicationAddKeyRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, KeyCredential keyCredential, PasswordCredential passwordCredential, String proof) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("keyCredential", keyCredential);
        this.bodyParams.put("passwordCredential", passwordCredential);
        this.bodyParams.put("proof", proof);
    }

    @Override
    public IApplicationAddKeyRequest buildRequest() {
        return this.buildRequest(this.getOptions());
    }

    @Override
    public IApplicationAddKeyRequest buildRequest(List<? extends Option> requestOptions) {
        ApplicationAddKeyRequest request = new ApplicationAddKeyRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("keyCredential")) {
            request.body.keyCredential = (KeyCredential)this.getParameter("keyCredential");
        }
        if (this.hasParameter("passwordCredential")) {
            request.body.passwordCredential = (PasswordCredential)this.getParameter("passwordCredential");
        }
        if (this.hasParameter("proof")) {
            request.body.proof = (String)this.getParameter("proof");
        }
        return request;
    }
}

