/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DirectoryObjectCheckMemberObjectsBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryObjectCheckMemberObjectsCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectCheckMemberObjectsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectCheckMemberObjectsCollectionResponse;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCheckMemberObjectsCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCheckMemberObjectsCollectionRequest;
import java.util.List;

public class DirectoryObjectCheckMemberObjectsCollectionRequest
extends BaseCollectionRequest<DirectoryObjectCheckMemberObjectsCollectionResponse, IDirectoryObjectCheckMemberObjectsCollectionPage>
implements IDirectoryObjectCheckMemberObjectsCollectionRequest {
    protected final DirectoryObjectCheckMemberObjectsBody body = new DirectoryObjectCheckMemberObjectsBody();

    public DirectoryObjectCheckMemberObjectsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectCheckMemberObjectsCollectionResponse.class, IDirectoryObjectCheckMemberObjectsCollectionPage.class);
    }

    @Override
    public void post(final ICallback<IDirectoryObjectCheckMemberObjectsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryObjectCheckMemberObjectsCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryObjectCheckMemberObjectsCollectionPage post() throws ClientException {
        DirectoryObjectCheckMemberObjectsCollectionResponse response = (DirectoryObjectCheckMemberObjectsCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IDirectoryObjectCheckMemberObjectsCollectionPage buildFromResponse(DirectoryObjectCheckMemberObjectsCollectionResponse response) {
        DirectoryObjectCheckMemberObjectsCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryObjectCheckMemberObjectsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DirectoryObjectCheckMemberObjectsCollectionPage page = new DirectoryObjectCheckMemberObjectsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryObjectCheckMemberObjectsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryObjectCheckMemberObjectsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDirectoryObjectCheckMemberObjectsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

