/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.DriveItemCopyBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDriveItemCopyRequest;
import java.util.List;

public class DriveItemCopyRequest
extends BaseRequest
implements IDriveItemCopyRequest {
    protected final DriveItemCopyBody body = new DriveItemCopyBody();

    public DriveItemCopyRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItem.class);
    }

    @Override
    public void post(ICallback<DriveItem> callback) {
        this.send(HttpMethod.POST, callback, this.body);
    }

    @Override
    public DriveItem post() throws ClientException {
        return (DriveItem)this.send(HttpMethod.POST, this.body);
    }

    @Override
    public IDriveItemCopyRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemCopyRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveItemCopyRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

