/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.RestrictedSignIn;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRestrictedSignInCollectionPage;
import com.microsoft.graph.requests.extensions.IRestrictedSignInCollectionRequest;
import com.microsoft.graph.requests.extensions.RestrictedSignInCollectionPage;
import com.microsoft.graph.requests.extensions.RestrictedSignInCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.RestrictedSignInCollectionResponse;
import com.microsoft.graph.requests.extensions.RestrictedSignInRequestBuilder;
import java.util.List;

public class RestrictedSignInCollectionRequest
extends BaseCollectionRequest<RestrictedSignInCollectionResponse, IRestrictedSignInCollectionPage>
implements IRestrictedSignInCollectionRequest {
    public RestrictedSignInCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RestrictedSignInCollectionResponse.class, IRestrictedSignInCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRestrictedSignInCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(RestrictedSignInCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRestrictedSignInCollectionPage get() throws ClientException {
        RestrictedSignInCollectionResponse response = (RestrictedSignInCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(RestrictedSignIn newRestrictedSignIn, ICallback<RestrictedSignIn> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new RestrictedSignInRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRestrictedSignIn, callback);
    }

    @Override
    public RestrictedSignIn post(RestrictedSignIn newRestrictedSignIn) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RestrictedSignInRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRestrictedSignIn);
    }

    @Override
    public IRestrictedSignInCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IRestrictedSignInCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRestrictedSignInCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IRestrictedSignInCollectionPage buildFromResponse(RestrictedSignInCollectionResponse response) {
        RestrictedSignInCollectionRequestBuilder builder = response.nextLink != null ? new RestrictedSignInCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RestrictedSignInCollectionPage page = new RestrictedSignInCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

