/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.RoleDefinition;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRoleDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.IRoleDefinitionCollectionRequest;
import com.microsoft.graph.requests.extensions.RoleDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.RoleDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.RoleDefinitionCollectionResponse;
import com.microsoft.graph.requests.extensions.RoleDefinitionRequestBuilder;
import java.util.List;

public class RoleDefinitionCollectionRequest
extends BaseCollectionRequest<RoleDefinitionCollectionResponse, IRoleDefinitionCollectionPage>
implements IRoleDefinitionCollectionRequest {
    public RoleDefinitionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoleDefinitionCollectionResponse.class, IRoleDefinitionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRoleDefinitionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(RoleDefinitionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRoleDefinitionCollectionPage get() throws ClientException {
        RoleDefinitionCollectionResponse response = (RoleDefinitionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(RoleDefinition newRoleDefinition, ICallback<RoleDefinition> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new RoleDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRoleDefinition, callback);
    }

    @Override
    public RoleDefinition post(RoleDefinition newRoleDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RoleDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRoleDefinition);
    }

    @Override
    public IRoleDefinitionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IRoleDefinitionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRoleDefinitionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IRoleDefinitionCollectionPage buildFromResponse(RoleDefinitionCollectionResponse response) {
        RoleDefinitionCollectionRequestBuilder builder = response.nextLink != null ? new RoleDefinitionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RoleDefinitionCollectionPage page = new RoleDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

