/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.UsedInsight;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUsedInsightCollectionPage;
import com.microsoft.graph.requests.extensions.IUsedInsightCollectionRequest;
import com.microsoft.graph.requests.extensions.UsedInsightCollectionPage;
import com.microsoft.graph.requests.extensions.UsedInsightCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UsedInsightCollectionResponse;
import com.microsoft.graph.requests.extensions.UsedInsightRequestBuilder;
import java.util.List;

public class UsedInsightCollectionRequest
extends BaseCollectionRequest<UsedInsightCollectionResponse, IUsedInsightCollectionPage>
implements IUsedInsightCollectionRequest {
    public UsedInsightCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UsedInsightCollectionResponse.class, IUsedInsightCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUsedInsightCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UsedInsightCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUsedInsightCollectionPage get() throws ClientException {
        UsedInsightCollectionResponse response = (UsedInsightCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(UsedInsight newUsedInsight, ICallback<UsedInsight> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UsedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUsedInsight, callback);
    }

    @Override
    public UsedInsight post(UsedInsight newUsedInsight) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UsedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUsedInsight);
    }

    @Override
    public IUsedInsightCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IUsedInsightCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUsedInsightCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IUsedInsightCollectionPage buildFromResponse(UsedInsightCollectionResponse response) {
        UsedInsightCollectionRequestBuilder builder = response.nextLink != null ? new UsedInsightCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UsedInsightCollectionPage page = new UsedInsightCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

