// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.ItemActionStat;
import com.microsoft.graph.models.extensions.IncompleteData;
import com.microsoft.graph.models.extensions.ItemActivity;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.ItemActivityCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Activity Stat.
 */
public class ItemActivityStat extends Entity implements IJsonBackedObject {


    /**
     * The Access.
     * Statistics about the access actions in this interval. Read-only.
     */
    @SerializedName(value = "access", alternate = {"Access"})
    @Expose
    public ItemActionStat access;

    /**
     * The Create.
     * Statistics about the create actions in this interval. Read-only.
     */
    @SerializedName(value = "create", alternate = {"Create"})
    @Expose
    public ItemActionStat create;

    /**
     * The Delete.
     * Statistics about the delete actions in this interval. Read-only.
     */
    @SerializedName(value = "delete", alternate = {"Delete"})
    @Expose
    public ItemActionStat delete;

    /**
     * The Edit.
     * Statistics about the edit actions in this interval. Read-only.
     */
    @SerializedName(value = "edit", alternate = {"Edit"})
    @Expose
    public ItemActionStat edit;

    /**
     * The End Date Time.
     * When the interval ends. Read-only.
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
    public java.util.Calendar endDateTime;

    /**
     * The Incomplete Data.
     * Indicates that the statistics in this interval are based on incomplete data. Read-only.
     */
    @SerializedName(value = "incompleteData", alternate = {"IncompleteData"})
    @Expose
    public IncompleteData incompleteData;

    /**
     * The Is Trending.
     * Indicates whether the item is 'trending.' Read-only.
     */
    @SerializedName(value = "isTrending", alternate = {"IsTrending"})
    @Expose
    public Boolean isTrending;

    /**
     * The Move.
     * Statistics about the move actions in this interval. Read-only.
     */
    @SerializedName(value = "move", alternate = {"Move"})
    @Expose
    public ItemActionStat move;

    /**
     * The Start Date Time.
     * When the interval starts. Read-only.
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
    public java.util.Calendar startDateTime;

    /**
     * The Activities.
     * Exposes the itemActivities represented in this itemActivityStat resource.
     */
    @SerializedName(value = "activities", alternate = {"Activities"})
    @Expose
    public ItemActivityCollectionPage activities;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("activities")) {
            activities = serializer.deserializeObject(json.get("activities").toString(), ItemActivityCollectionPage.class);
        }
    }
}
