// Template Source: BaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AgreementAcceptance;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Acceptance Reference Request.
 */
public class AgreementAcceptanceReferenceRequest extends BaseRequest implements IAgreementAcceptanceReferenceRequest {

    /**
     * The request for the AgreementAcceptance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementAcceptanceReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementAcceptance.class);
    }

    public void delete(final ICallback<? super AgreementAcceptance> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public AgreementAcceptance delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IAgreementAcceptanceReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (AgreementAcceptanceReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IAgreementAcceptanceReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (AgreementAcceptanceReferenceRequest)this;
    }
    /**
     * Puts the AgreementAcceptance
     *
     * @param srcAgreementAcceptance the AgreementAcceptance reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(AgreementAcceptance srcAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback) {
        send(HttpMethod.PUT, callback, srcAgreementAcceptance);
    }

    /**
     * Puts the AgreementAcceptance
     *
     * @param srcAgreementAcceptance the AgreementAcceptance reference to PUT
     * @return the AgreementAcceptance
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public AgreementAcceptance put(AgreementAcceptance srcAgreementAcceptance) throws ClientException {
        return send(HttpMethod.PUT, srcAgreementAcceptance);
    }
}
