// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AgreementAcceptance;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Agreement Acceptance Request.
 */
public interface IAgreementAcceptanceRequest extends IHttpRequest {

    /**
     * Gets the AgreementAcceptance from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AgreementAcceptance> callback);

    /**
     * Gets the AgreementAcceptance from the service
     *
     * @return the AgreementAcceptance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementAcceptance get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AgreementAcceptance> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AgreementAcceptance with a source
     *
     * @param sourceAgreementAcceptance the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AgreementAcceptance sourceAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback);

    /**
     * Patches this AgreementAcceptance with a source
     *
     * @param sourceAgreementAcceptance the source object with updates
     * @return the updated AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementAcceptance patch(final AgreementAcceptance sourceAgreementAcceptance) throws ClientException;

    /**
     * Posts a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AgreementAcceptance newAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback);

    /**
     * Posts a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the new object to create
     * @return the created AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementAcceptance post(final AgreementAcceptance newAgreementAcceptance) throws ClientException;

    /**
     * Posts a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AgreementAcceptance newAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback);

    /**
     * Posts a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the object to create/update
     * @return the created AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementAcceptance put(final AgreementAcceptance newAgreementAcceptance) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAgreementAcceptanceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAgreementAcceptanceRequest expand(final String value);

}

