// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AgreementFileLocalization;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Agreement File Localization Request.
 */
public interface IAgreementFileLocalizationRequest extends IHttpRequest {

    /**
     * Gets the AgreementFileLocalization from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AgreementFileLocalization> callback);

    /**
     * Gets the AgreementFileLocalization from the service
     *
     * @return the AgreementFileLocalization from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileLocalization get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AgreementFileLocalization> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AgreementFileLocalization with a source
     *
     * @param sourceAgreementFileLocalization the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AgreementFileLocalization sourceAgreementFileLocalization, final ICallback<? super AgreementFileLocalization> callback);

    /**
     * Patches this AgreementFileLocalization with a source
     *
     * @param sourceAgreementFileLocalization the source object with updates
     * @return the updated AgreementFileLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileLocalization patch(final AgreementFileLocalization sourceAgreementFileLocalization) throws ClientException;

    /**
     * Posts a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AgreementFileLocalization newAgreementFileLocalization, final ICallback<? super AgreementFileLocalization> callback);

    /**
     * Posts a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the new object to create
     * @return the created AgreementFileLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileLocalization post(final AgreementFileLocalization newAgreementFileLocalization) throws ClientException;

    /**
     * Posts a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AgreementFileLocalization newAgreementFileLocalization, final ICallback<? super AgreementFileLocalization> callback);

    /**
     * Posts a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the object to create/update
     * @return the created AgreementFileLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileLocalization put(final AgreementFileLocalization newAgreementFileLocalization) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAgreementFileLocalizationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAgreementFileLocalizationRequest expand(final String value);

}

