// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AgreementFile;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Agreement File Request.
 */
public interface IAgreementFileRequest extends IHttpRequest {

    /**
     * Gets the AgreementFile from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AgreementFile> callback);

    /**
     * Gets the AgreementFile from the service
     *
     * @return the AgreementFile from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFile get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AgreementFile> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AgreementFile with a source
     *
     * @param sourceAgreementFile the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AgreementFile sourceAgreementFile, final ICallback<? super AgreementFile> callback);

    /**
     * Patches this AgreementFile with a source
     *
     * @param sourceAgreementFile the source object with updates
     * @return the updated AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFile patch(final AgreementFile sourceAgreementFile) throws ClientException;

    /**
     * Posts a AgreementFile with a new object
     *
     * @param newAgreementFile the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AgreementFile newAgreementFile, final ICallback<? super AgreementFile> callback);

    /**
     * Posts a AgreementFile with a new object
     *
     * @param newAgreementFile the new object to create
     * @return the created AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFile post(final AgreementFile newAgreementFile) throws ClientException;

    /**
     * Posts a AgreementFile with a new object
     *
     * @param newAgreementFile the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AgreementFile newAgreementFile, final ICallback<? super AgreementFile> callback);

    /**
     * Posts a AgreementFile with a new object
     *
     * @param newAgreementFile the object to create/update
     * @return the created AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFile put(final AgreementFile newAgreementFile) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAgreementFileRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAgreementFileRequest expand(final String value);

}

