// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceConfigurationDeviceOverview;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Configuration Device Overview Request.
 */
public interface IDeviceConfigurationDeviceOverviewRequest extends IHttpRequest {

    /**
     * Gets the DeviceConfigurationDeviceOverview from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DeviceConfigurationDeviceOverview> callback);

    /**
     * Gets the DeviceConfigurationDeviceOverview from the service
     *
     * @return the DeviceConfigurationDeviceOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceOverview get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DeviceConfigurationDeviceOverview> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceConfigurationDeviceOverview with a source
     *
     * @param sourceDeviceConfigurationDeviceOverview the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceConfigurationDeviceOverview sourceDeviceConfigurationDeviceOverview, final ICallback<? super DeviceConfigurationDeviceOverview> callback);

    /**
     * Patches this DeviceConfigurationDeviceOverview with a source
     *
     * @param sourceDeviceConfigurationDeviceOverview the source object with updates
     * @return the updated DeviceConfigurationDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceOverview patch(final DeviceConfigurationDeviceOverview sourceDeviceConfigurationDeviceOverview) throws ClientException;

    /**
     * Posts a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview, final ICallback<? super DeviceConfigurationDeviceOverview> callback);

    /**
     * Posts a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the new object to create
     * @return the created DeviceConfigurationDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceOverview post(final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview) throws ClientException;

    /**
     * Posts a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview, final ICallback<? super DeviceConfigurationDeviceOverview> callback);

    /**
     * Posts a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the object to create/update
     * @return the created DeviceConfigurationDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceOverview put(final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceConfigurationDeviceOverviewRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceConfigurationDeviceOverviewRequest expand(final String value);

}

