// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Device;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IGroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IApplicationWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IServicePrincipalWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IOrgContactWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IAppRoleAssignmentWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IEndpointWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Request Builder.
 */
public interface IDeviceRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IDeviceRequest instance
     */
    IDeviceRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IDeviceRequest instance
     */
    IDeviceRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IDirectoryObjectCollectionWithReferencesRequestBuilder memberOf();

    IDirectoryObjectWithReferenceRequestBuilder memberOf(final String id);

    IUserCollectionWithReferencesRequestBuilder memberOfAsUser();

    IUserWithReferenceRequestBuilder memberOfAsUser(final String id);

    IGroupCollectionWithReferencesRequestBuilder memberOfAsGroup();

    IGroupWithReferenceRequestBuilder memberOfAsGroup(final String id);

    IApplicationCollectionWithReferencesRequestBuilder memberOfAsApplication();

    IApplicationWithReferenceRequestBuilder memberOfAsApplication(final String id);

    IServicePrincipalCollectionWithReferencesRequestBuilder memberOfAsServicePrincipal();

    IServicePrincipalWithReferenceRequestBuilder memberOfAsServicePrincipal(final String id);

    IDeviceCollectionWithReferencesRequestBuilder memberOfAsDevice();

    IDeviceWithReferenceRequestBuilder memberOfAsDevice(final String id);

    IOrgContactCollectionWithReferencesRequestBuilder memberOfAsOrgContact();

    IOrgContactWithReferenceRequestBuilder memberOfAsOrgContact(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder registeredOwners();

    IDirectoryObjectWithReferenceRequestBuilder registeredOwners(final String id);

    IAppRoleAssignmentCollectionWithReferencesRequestBuilder registeredOwnersAsAppRoleAssignment();

    IAppRoleAssignmentWithReferenceRequestBuilder registeredOwnersAsAppRoleAssignment(final String id);

    IEndpointCollectionWithReferencesRequestBuilder registeredOwnersAsEndpoint();

    IEndpointWithReferenceRequestBuilder registeredOwnersAsEndpoint(final String id);

    IServicePrincipalCollectionWithReferencesRequestBuilder registeredOwnersAsServicePrincipal();

    IServicePrincipalWithReferenceRequestBuilder registeredOwnersAsServicePrincipal(final String id);

    IUserCollectionWithReferencesRequestBuilder registeredOwnersAsUser();

    IUserWithReferenceRequestBuilder registeredOwnersAsUser(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder registeredUsers();

    IDirectoryObjectWithReferenceRequestBuilder registeredUsers(final String id);

    IAppRoleAssignmentCollectionWithReferencesRequestBuilder registeredUsersAsAppRoleAssignment();

    IAppRoleAssignmentWithReferenceRequestBuilder registeredUsersAsAppRoleAssignment(final String id);

    IEndpointCollectionWithReferencesRequestBuilder registeredUsersAsEndpoint();

    IEndpointWithReferenceRequestBuilder registeredUsersAsEndpoint(final String id);

    IServicePrincipalCollectionWithReferencesRequestBuilder registeredUsersAsServicePrincipal();

    IServicePrincipalWithReferenceRequestBuilder registeredUsersAsServicePrincipal(final String id);

    IUserCollectionWithReferencesRequestBuilder registeredUsersAsUser();

    IUserWithReferenceRequestBuilder registeredUsersAsUser(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder transitiveMemberOf();

    IDirectoryObjectWithReferenceRequestBuilder transitiveMemberOf(final String id);

    IUserCollectionWithReferencesRequestBuilder transitiveMemberOfAsUser();

    IUserWithReferenceRequestBuilder transitiveMemberOfAsUser(final String id);

    IGroupCollectionWithReferencesRequestBuilder transitiveMemberOfAsGroup();

    IGroupWithReferenceRequestBuilder transitiveMemberOfAsGroup(final String id);

    IApplicationCollectionWithReferencesRequestBuilder transitiveMemberOfAsApplication();

    IApplicationWithReferenceRequestBuilder transitiveMemberOfAsApplication(final String id);

    IServicePrincipalCollectionWithReferencesRequestBuilder transitiveMemberOfAsServicePrincipal();

    IServicePrincipalWithReferenceRequestBuilder transitiveMemberOfAsServicePrincipal(final String id);

    IDeviceCollectionWithReferencesRequestBuilder transitiveMemberOfAsDevice();

    IDeviceWithReferenceRequestBuilder transitiveMemberOfAsDevice(final String id);

    IOrgContactCollectionWithReferencesRequestBuilder transitiveMemberOfAsOrgContact();

    IOrgContactWithReferenceRequestBuilder transitiveMemberOfAsOrgContact(final String id);

    IExtensionCollectionRequestBuilder extensions();

    IExtensionRequestBuilder extensions(final String id);

}