// Template Source: IBaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.models.extensions.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Directory Object Reference Request.
 */
public interface IDirectoryObjectReferenceRequest extends IHttpRequest {

    void delete(final ICallback<? super DirectoryObject> callback);

    DirectoryObject delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDirectoryObjectReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDirectoryObjectReferenceRequest expand(final String value);

    /**
     * Puts the DirectoryObject
     *
     * @param srcDirectoryObject the DirectoryObject to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(DirectoryObject srcDirectoryObject, final ICallback<? super DirectoryObject> callback);

    /**
     * Puts the DirectoryObject
     *
     * @param srcDirectoryObject the DirectoryObject to PUT
     * @return the DirectoryObject
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    DirectoryObject put(DirectoryObject srcDirectoryObject) throws ClientException;
}
