// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.EmailFileAssessmentRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Email File Assessment Request Request.
 */
public interface IEmailFileAssessmentRequestRequest extends IHttpRequest {

    /**
     * Gets the EmailFileAssessmentRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super EmailFileAssessmentRequest> callback);

    /**
     * Gets the EmailFileAssessmentRequest from the service
     *
     * @return the EmailFileAssessmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EmailFileAssessmentRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super EmailFileAssessmentRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EmailFileAssessmentRequest with a source
     *
     * @param sourceEmailFileAssessmentRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final EmailFileAssessmentRequest sourceEmailFileAssessmentRequest, final ICallback<? super EmailFileAssessmentRequest> callback);

    /**
     * Patches this EmailFileAssessmentRequest with a source
     *
     * @param sourceEmailFileAssessmentRequest the source object with updates
     * @return the updated EmailFileAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EmailFileAssessmentRequest patch(final EmailFileAssessmentRequest sourceEmailFileAssessmentRequest) throws ClientException;

    /**
     * Posts a EmailFileAssessmentRequest with a new object
     *
     * @param newEmailFileAssessmentRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final EmailFileAssessmentRequest newEmailFileAssessmentRequest, final ICallback<? super EmailFileAssessmentRequest> callback);

    /**
     * Posts a EmailFileAssessmentRequest with a new object
     *
     * @param newEmailFileAssessmentRequest the new object to create
     * @return the created EmailFileAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EmailFileAssessmentRequest post(final EmailFileAssessmentRequest newEmailFileAssessmentRequest) throws ClientException;

    /**
     * Posts a EmailFileAssessmentRequest with a new object
     *
     * @param newEmailFileAssessmentRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final EmailFileAssessmentRequest newEmailFileAssessmentRequest, final ICallback<? super EmailFileAssessmentRequest> callback);

    /**
     * Posts a EmailFileAssessmentRequest with a new object
     *
     * @param newEmailFileAssessmentRequest the object to create/update
     * @return the created EmailFileAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EmailFileAssessmentRequest put(final EmailFileAssessmentRequest newEmailFileAssessmentRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IEmailFileAssessmentRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IEmailFileAssessmentRequestRequest expand(final String value);

}

