// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Fido2AuthenticationMethod;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Fido2Authentication Method Request.
 */
public interface IFido2AuthenticationMethodRequest extends IHttpRequest {

    /**
     * Gets the Fido2AuthenticationMethod from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Fido2AuthenticationMethod> callback);

    /**
     * Gets the Fido2AuthenticationMethod from the service
     *
     * @return the Fido2AuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Fido2AuthenticationMethod get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Fido2AuthenticationMethod> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Fido2AuthenticationMethod with a source
     *
     * @param sourceFido2AuthenticationMethod the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Fido2AuthenticationMethod sourceFido2AuthenticationMethod, final ICallback<? super Fido2AuthenticationMethod> callback);

    /**
     * Patches this Fido2AuthenticationMethod with a source
     *
     * @param sourceFido2AuthenticationMethod the source object with updates
     * @return the updated Fido2AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Fido2AuthenticationMethod patch(final Fido2AuthenticationMethod sourceFido2AuthenticationMethod) throws ClientException;

    /**
     * Posts a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Fido2AuthenticationMethod newFido2AuthenticationMethod, final ICallback<? super Fido2AuthenticationMethod> callback);

    /**
     * Posts a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the new object to create
     * @return the created Fido2AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Fido2AuthenticationMethod post(final Fido2AuthenticationMethod newFido2AuthenticationMethod) throws ClientException;

    /**
     * Posts a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Fido2AuthenticationMethod newFido2AuthenticationMethod, final ICallback<? super Fido2AuthenticationMethod> callback);

    /**
     * Posts a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the object to create/update
     * @return the created Fido2AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Fido2AuthenticationMethod put(final Fido2AuthenticationMethod newFido2AuthenticationMethod) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IFido2AuthenticationMethodRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IFido2AuthenticationMethodRequest expand(final String value);

}

