// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedAppOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed App Operation Request.
 */
public interface IManagedAppOperationRequest extends IHttpRequest {

    /**
     * Gets the ManagedAppOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ManagedAppOperation> callback);

    /**
     * Gets the ManagedAppOperation from the service
     *
     * @return the ManagedAppOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAppOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ManagedAppOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedAppOperation with a source
     *
     * @param sourceManagedAppOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedAppOperation sourceManagedAppOperation, final ICallback<? super ManagedAppOperation> callback);

    /**
     * Patches this ManagedAppOperation with a source
     *
     * @param sourceManagedAppOperation the source object with updates
     * @return the updated ManagedAppOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAppOperation patch(final ManagedAppOperation sourceManagedAppOperation) throws ClientException;

    /**
     * Posts a ManagedAppOperation with a new object
     *
     * @param newManagedAppOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedAppOperation newManagedAppOperation, final ICallback<? super ManagedAppOperation> callback);

    /**
     * Posts a ManagedAppOperation with a new object
     *
     * @param newManagedAppOperation the new object to create
     * @return the created ManagedAppOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAppOperation post(final ManagedAppOperation newManagedAppOperation) throws ClientException;

    /**
     * Posts a ManagedAppOperation with a new object
     *
     * @param newManagedAppOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ManagedAppOperation newManagedAppOperation, final ICallback<? super ManagedAppOperation> callback);

    /**
     * Posts a ManagedAppOperation with a new object
     *
     * @param newManagedAppOperation the object to create/update
     * @return the created ManagedAppOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAppOperation put(final ManagedAppOperation newManagedAppOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedAppOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedAppOperationRequest expand(final String value);

}

