// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.OrganizationalBrandingProperties;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Organizational Branding Properties Request.
 */
public interface IOrganizationalBrandingPropertiesRequest extends IHttpRequest {

    /**
     * Gets the OrganizationalBrandingProperties from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super OrganizationalBrandingProperties> callback);

    /**
     * Gets the OrganizationalBrandingProperties from the service
     *
     * @return the OrganizationalBrandingProperties from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingProperties get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super OrganizationalBrandingProperties> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OrganizationalBrandingProperties with a source
     *
     * @param sourceOrganizationalBrandingProperties the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final OrganizationalBrandingProperties sourceOrganizationalBrandingProperties, final ICallback<? super OrganizationalBrandingProperties> callback);

    /**
     * Patches this OrganizationalBrandingProperties with a source
     *
     * @param sourceOrganizationalBrandingProperties the source object with updates
     * @return the updated OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingProperties patch(final OrganizationalBrandingProperties sourceOrganizationalBrandingProperties) throws ClientException;

    /**
     * Posts a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final OrganizationalBrandingProperties newOrganizationalBrandingProperties, final ICallback<? super OrganizationalBrandingProperties> callback);

    /**
     * Posts a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the new object to create
     * @return the created OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingProperties post(final OrganizationalBrandingProperties newOrganizationalBrandingProperties) throws ClientException;

    /**
     * Posts a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final OrganizationalBrandingProperties newOrganizationalBrandingProperties, final ICallback<? super OrganizationalBrandingProperties> callback);

    /**
     * Posts a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the object to create/update
     * @return the created OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingProperties put(final OrganizationalBrandingProperties newOrganizationalBrandingProperties) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOrganizationalBrandingPropertiesRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOrganizationalBrandingPropertiesRequest expand(final String value);

}

