// Template Source: IBaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TokenIssuancePolicy;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.TokenIssuancePolicy;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Token Issuance Policy With Reference Request.
 */
public interface ITokenIssuancePolicyWithReferenceRequest extends IHttpRequest {

    void post(final TokenIssuancePolicy newTokenIssuancePolicy, final IJsonBackedObject payload, final ICallback<? super TokenIssuancePolicy> callback);

    TokenIssuancePolicy post(final TokenIssuancePolicy newTokenIssuancePolicy, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super TokenIssuancePolicy> callback);

    TokenIssuancePolicy get() throws ClientException;

	void delete(final ICallback<? super TokenIssuancePolicy> callback);

	void delete() throws ClientException;

	void patch(final TokenIssuancePolicy sourceTokenIssuancePolicy, final ICallback<? super TokenIssuancePolicy> callback);

	TokenIssuancePolicy patch(final TokenIssuancePolicy sourceTokenIssuancePolicy) throws ClientException;

    ITokenIssuancePolicyWithReferenceRequest select(final String value);

    ITokenIssuancePolicyWithReferenceRequest expand(final String value);

}
