// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WindowsPhone81CompliancePolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Windows Phone81Compliance Policy Request.
 */
public interface IWindowsPhone81CompliancePolicyRequest extends IHttpRequest {

    /**
     * Gets the WindowsPhone81CompliancePolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WindowsPhone81CompliancePolicy> callback);

    /**
     * Gets the WindowsPhone81CompliancePolicy from the service
     *
     * @return the WindowsPhone81CompliancePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsPhone81CompliancePolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WindowsPhone81CompliancePolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WindowsPhone81CompliancePolicy with a source
     *
     * @param sourceWindowsPhone81CompliancePolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WindowsPhone81CompliancePolicy sourceWindowsPhone81CompliancePolicy, final ICallback<? super WindowsPhone81CompliancePolicy> callback);

    /**
     * Patches this WindowsPhone81CompliancePolicy with a source
     *
     * @param sourceWindowsPhone81CompliancePolicy the source object with updates
     * @return the updated WindowsPhone81CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsPhone81CompliancePolicy patch(final WindowsPhone81CompliancePolicy sourceWindowsPhone81CompliancePolicy) throws ClientException;

    /**
     * Posts a WindowsPhone81CompliancePolicy with a new object
     *
     * @param newWindowsPhone81CompliancePolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WindowsPhone81CompliancePolicy newWindowsPhone81CompliancePolicy, final ICallback<? super WindowsPhone81CompliancePolicy> callback);

    /**
     * Posts a WindowsPhone81CompliancePolicy with a new object
     *
     * @param newWindowsPhone81CompliancePolicy the new object to create
     * @return the created WindowsPhone81CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsPhone81CompliancePolicy post(final WindowsPhone81CompliancePolicy newWindowsPhone81CompliancePolicy) throws ClientException;

    /**
     * Posts a WindowsPhone81CompliancePolicy with a new object
     *
     * @param newWindowsPhone81CompliancePolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WindowsPhone81CompliancePolicy newWindowsPhone81CompliancePolicy, final ICallback<? super WindowsPhone81CompliancePolicy> callback);

    /**
     * Posts a WindowsPhone81CompliancePolicy with a new object
     *
     * @param newWindowsPhone81CompliancePolicy the object to create/update
     * @return the created WindowsPhone81CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsPhone81CompliancePolicy put(final WindowsPhone81CompliancePolicy newWindowsPhone81CompliancePolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWindowsPhone81CompliancePolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWindowsPhone81CompliancePolicyRequest expand(final String value);

}

