// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceDeleteUserFromSharedAppleDeviceRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceDeleteUserFromSharedAppleDeviceRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Delete User From Shared Apple Device Request Builder.
 */
public class ManagedDeviceDeleteUserFromSharedAppleDeviceRequestBuilder extends BaseActionRequestBuilder implements IManagedDeviceDeleteUserFromSharedAppleDeviceRequestBuilder {

    /**
     * The request builder for this ManagedDeviceDeleteUserFromSharedAppleDevice
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param userPrincipalName the userPrincipalName
     */
    public ManagedDeviceDeleteUserFromSharedAppleDeviceRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String userPrincipalName) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("userPrincipalName", userPrincipalName);
    }

    /**
     * Creates the IManagedDeviceDeleteUserFromSharedAppleDeviceRequest
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceDeleteUserFromSharedAppleDeviceRequest instance
     */
    public IManagedDeviceDeleteUserFromSharedAppleDeviceRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IManagedDeviceDeleteUserFromSharedAppleDeviceRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceDeleteUserFromSharedAppleDeviceRequest instance
     */
    public IManagedDeviceDeleteUserFromSharedAppleDeviceRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ManagedDeviceDeleteUserFromSharedAppleDeviceRequest request = new ManagedDeviceDeleteUserFromSharedAppleDeviceRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("userPrincipalName")) {
            request.body.userPrincipalName = getParameter("userPrincipalName");
        }

        return request;
    }
}
