// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OrganizationalBrandingProperties;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Properties Request.
 */
public class OrganizationalBrandingPropertiesRequest extends BaseRequest implements IOrganizationalBrandingPropertiesRequest {
	
    /**
     * The request for the OrganizationalBrandingProperties
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public OrganizationalBrandingPropertiesRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends OrganizationalBrandingProperties> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the OrganizationalBrandingProperties
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrganizationalBrandingPropertiesRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrganizationalBrandingProperties.class);
    }

    /**
     * Gets the OrganizationalBrandingProperties from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super OrganizationalBrandingProperties> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OrganizationalBrandingProperties from the service
     *
     * @return the OrganizationalBrandingProperties from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingProperties get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super OrganizationalBrandingProperties> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OrganizationalBrandingProperties with a source
     *
     * @param sourceOrganizationalBrandingProperties the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OrganizationalBrandingProperties sourceOrganizationalBrandingProperties, final ICallback<? super OrganizationalBrandingProperties> callback) {
        send(HttpMethod.PATCH, callback, sourceOrganizationalBrandingProperties);
    }

    /**
     * Patches this OrganizationalBrandingProperties with a source
     *
     * @param sourceOrganizationalBrandingProperties the source object with updates
     * @return the updated OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingProperties patch(final OrganizationalBrandingProperties sourceOrganizationalBrandingProperties) throws ClientException {
        return send(HttpMethod.PATCH, sourceOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OrganizationalBrandingProperties newOrganizationalBrandingProperties, final ICallback<? super OrganizationalBrandingProperties> callback) {
        send(HttpMethod.POST, callback, newOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the new object to create
     * @return the created OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingProperties post(final OrganizationalBrandingProperties newOrganizationalBrandingProperties) throws ClientException {
        return send(HttpMethod.POST, newOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final OrganizationalBrandingProperties newOrganizationalBrandingProperties, final ICallback<? super OrganizationalBrandingProperties> callback) {
        send(HttpMethod.PUT, callback, newOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the object to create/update
     * @return the created OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingProperties put(final OrganizationalBrandingProperties newOrganizationalBrandingProperties) throws ClientException {
        return send(HttpMethod.PUT, newOrganizationalBrandingProperties);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOrganizationalBrandingPropertiesRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (OrganizationalBrandingPropertiesRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOrganizationalBrandingPropertiesRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (OrganizationalBrandingPropertiesRequest)this;
     }

}

