// Template Source: BaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintConnector;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Connector Reference Request.
 */
public class PrintConnectorReferenceRequest extends BaseRequest implements IPrintConnectorReferenceRequest {

    /**
     * The request for the PrintConnector
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintConnectorReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintConnector.class);
    }

    public void delete(final ICallback<? super PrintConnector> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public PrintConnector delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IPrintConnectorReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (PrintConnectorReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IPrintConnectorReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (PrintConnectorReferenceRequest)this;
    }
    /**
     * Puts the PrintConnector
     *
     * @param srcPrintConnector the PrintConnector reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(PrintConnector srcPrintConnector, final ICallback<? super PrintConnector> callback) {
        send(HttpMethod.PUT, callback, srcPrintConnector);
    }

    /**
     * Puts the PrintConnector
     *
     * @param srcPrintConnector the PrintConnector reference to PUT
     * @return the PrintConnector
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public PrintConnector put(PrintConnector srcPrintConnector) throws ClientException {
        return send(HttpMethod.PUT, srcPrintConnector);
    }
}
