// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IPrintJobAbortRequest;
import com.microsoft.graph.requests.extensions.PrintJobAbortRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job Abort Request Builder.
 */
public class PrintJobAbortRequestBuilder extends BaseActionRequestBuilder implements IPrintJobAbortRequestBuilder {

    /**
     * The request builder for this PrintJobAbort
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param reason the reason
     */
    public PrintJobAbortRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String reason) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("reason", reason);
    }

    /**
     * Creates the IPrintJobAbortRequest
     *
     * @param requestOptions the options for the request
     * @return the IPrintJobAbortRequest instance
     */
    public IPrintJobAbortRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IPrintJobAbortRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IPrintJobAbortRequest instance
     */
    public IPrintJobAbortRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        PrintJobAbortRequest request = new PrintJobAbortRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("reason")) {
            request.body.reason = getParameter("reason");
        }

        return request;
    }
}
