// Template Source: BaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintTaskDefinition;
import com.microsoft.graph.requests.extensions.IPrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Task Definition Reference Request.
 */
public class PrintTaskDefinitionReferenceRequest extends BaseRequest implements IPrintTaskDefinitionReferenceRequest {

    /**
     * The request for the PrintTaskDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintTaskDefinitionReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintTaskDefinition.class);
    }

    public void delete(final ICallback<? super PrintTaskDefinition> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public PrintTaskDefinition delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IPrintTaskDefinitionReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (PrintTaskDefinitionReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IPrintTaskDefinitionReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (PrintTaskDefinitionReferenceRequest)this;
    }
    /**
     * Puts the PrintTaskDefinition
     *
     * @param srcPrintTaskDefinition the PrintTaskDefinition reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(PrintTaskDefinition srcPrintTaskDefinition, final ICallback<? super PrintTaskDefinition> callback) {
        send(HttpMethod.PUT, callback, srcPrintTaskDefinition);
    }

    /**
     * Puts the PrintTaskDefinition
     *
     * @param srcPrintTaskDefinition the PrintTaskDefinition reference to PUT
     * @return the PrintTaskDefinition
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public PrintTaskDefinition put(PrintTaskDefinition srcPrintTaskDefinition) throws ClientException {
        return send(HttpMethod.PUT, srcPrintTaskDefinition);
    }
}
