// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrinterCreateOperation;
import com.microsoft.graph.requests.extensions.IPrinterWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Create Operation Request.
 */
public class PrinterCreateOperationRequest extends BaseRequest implements IPrinterCreateOperationRequest {
	
    /**
     * The request for the PrinterCreateOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterCreateOperationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterCreateOperation.class);
    }

    /**
     * Gets the PrinterCreateOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super PrinterCreateOperation> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the PrinterCreateOperation from the service
     *
     * @return the PrinterCreateOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrinterCreateOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super PrinterCreateOperation> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrinterCreateOperation with a source
     *
     * @param sourcePrinterCreateOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final PrinterCreateOperation sourcePrinterCreateOperation, final ICallback<? super PrinterCreateOperation> callback) {
        send(HttpMethod.PATCH, callback, sourcePrinterCreateOperation);
    }

    /**
     * Patches this PrinterCreateOperation with a source
     *
     * @param sourcePrinterCreateOperation the source object with updates
     * @return the updated PrinterCreateOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrinterCreateOperation patch(final PrinterCreateOperation sourcePrinterCreateOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrinterCreateOperation);
    }

    /**
     * Creates a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final PrinterCreateOperation newPrinterCreateOperation, final ICallback<? super PrinterCreateOperation> callback) {
        send(HttpMethod.POST, callback, newPrinterCreateOperation);
    }

    /**
     * Creates a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the new object to create
     * @return the created PrinterCreateOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrinterCreateOperation post(final PrinterCreateOperation newPrinterCreateOperation) throws ClientException {
        return send(HttpMethod.POST, newPrinterCreateOperation);
    }

    /**
     * Creates a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final PrinterCreateOperation newPrinterCreateOperation, final ICallback<? super PrinterCreateOperation> callback) {
        send(HttpMethod.PUT, callback, newPrinterCreateOperation);
    }

    /**
     * Creates a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the object to create/update
     * @return the created PrinterCreateOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrinterCreateOperation put(final PrinterCreateOperation newPrinterCreateOperation) throws ClientException {
        return send(HttpMethod.PUT, newPrinterCreateOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPrinterCreateOperationRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PrinterCreateOperationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPrinterCreateOperationRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PrinterCreateOperationRequest)this;
     }

}

