// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IPrinterCreateRequest;
import com.microsoft.graph.requests.extensions.PrinterCreateRequest;
import com.microsoft.graph.models.extensions.PrintCertificateSigningRequest;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Create Request Builder.
 */
public class PrinterCreateRequestBuilder extends BaseActionRequestBuilder implements IPrinterCreateRequestBuilder {

    /**
     * The request builder for this PrinterCreate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param displayName the displayName
     * @param manufacturer the manufacturer
     * @param model the model
     * @param physicalDeviceId the physicalDeviceId
     * @param hasPhysicalDevice the hasPhysicalDevice
     * @param certificateSigningRequest the certificateSigningRequest
     * @param connectorId the connectorId
     */
    public PrinterCreateRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String displayName, final String manufacturer, final String model, final String physicalDeviceId, final Boolean hasPhysicalDevice, final PrintCertificateSigningRequest certificateSigningRequest, final String connectorId) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("displayName", displayName);
        bodyParams.put("manufacturer", manufacturer);
        bodyParams.put("model", model);
        bodyParams.put("physicalDeviceId", physicalDeviceId);
        bodyParams.put("hasPhysicalDevice", hasPhysicalDevice);
        bodyParams.put("certificateSigningRequest", certificateSigningRequest);
        bodyParams.put("connectorId", connectorId);
    }

    /**
     * Creates the IPrinterCreateRequest
     *
     * @param requestOptions the options for the request
     * @return the IPrinterCreateRequest instance
     */
    public IPrinterCreateRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IPrinterCreateRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IPrinterCreateRequest instance
     */
    public IPrinterCreateRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        PrinterCreateRequest request = new PrinterCreateRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("displayName")) {
            request.body.displayName = getParameter("displayName");
        }

        if (hasParameter("manufacturer")) {
            request.body.manufacturer = getParameter("manufacturer");
        }

        if (hasParameter("model")) {
            request.body.model = getParameter("model");
        }

        if (hasParameter("physicalDeviceId")) {
            request.body.physicalDeviceId = getParameter("physicalDeviceId");
        }

        if (hasParameter("hasPhysicalDevice")) {
            request.body.hasPhysicalDevice = getParameter("hasPhysicalDevice");
        }

        if (hasParameter("certificateSigningRequest")) {
            request.body.certificateSigningRequest = getParameter("certificateSigningRequest");
        }

        if (hasParameter("connectorId")) {
            request.body.connectorId = getParameter("connectorId");
        }

        return request;
    }
}
