// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IRemoteAssistancePartnerBeginOnboardingRequest;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerBeginOnboardingRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Remote Assistance Partner Begin Onboarding Request Builder.
 */
public class RemoteAssistancePartnerBeginOnboardingRequestBuilder extends BaseActionRequestBuilder implements IRemoteAssistancePartnerBeginOnboardingRequestBuilder {

    /**
     * The request builder for this RemoteAssistancePartnerBeginOnboarding
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RemoteAssistancePartnerBeginOnboardingRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IRemoteAssistancePartnerBeginOnboardingRequest
     *
     * @param requestOptions the options for the request
     * @return the IRemoteAssistancePartnerBeginOnboardingRequest instance
     */
    public IRemoteAssistancePartnerBeginOnboardingRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IRemoteAssistancePartnerBeginOnboardingRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IRemoteAssistancePartnerBeginOnboardingRequest instance
     */
    public IRemoteAssistancePartnerBeginOnboardingRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        RemoteAssistancePartnerBeginOnboardingRequest request = new RemoteAssistancePartnerBeginOnboardingRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
