/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.SearchEntity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISearchEntityRequest;
import java.util.List;

public class SearchEntityRequest
extends BaseRequest
implements ISearchEntityRequest {
    public SearchEntityRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SearchEntity.class);
    }

    @Override
    public void get(ICallback<? super SearchEntity> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public SearchEntity get() throws ClientException {
        return (SearchEntity)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super SearchEntity> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(SearchEntity sourceSearchEntity, ICallback<? super SearchEntity> callback) {
        this.send(HttpMethod.PATCH, callback, sourceSearchEntity);
    }

    @Override
    public SearchEntity patch(SearchEntity sourceSearchEntity) throws ClientException {
        return (SearchEntity)this.send(HttpMethod.PATCH, sourceSearchEntity);
    }

    @Override
    public void post(SearchEntity newSearchEntity, ICallback<? super SearchEntity> callback) {
        this.send(HttpMethod.POST, callback, newSearchEntity);
    }

    @Override
    public SearchEntity post(SearchEntity newSearchEntity) throws ClientException {
        return (SearchEntity)this.send(HttpMethod.POST, newSearchEntity);
    }

    @Override
    public void put(SearchEntity newSearchEntity, ICallback<? super SearchEntity> callback) {
        this.send(HttpMethod.PUT, callback, newSearchEntity);
    }

    @Override
    public SearchEntity put(SearchEntity newSearchEntity) throws ClientException {
        return (SearchEntity)this.send(HttpMethod.PUT, newSearchEntity);
    }

    @Override
    public ISearchEntityRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISearchEntityRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

