/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITodoTaskListDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.ITodoTaskListDeltaCollectionRequest;
import com.microsoft.graph.requests.extensions.TodoTaskListDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.TodoTaskListDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TodoTaskListDeltaCollectionResponse;
import java.util.List;

public class TodoTaskListDeltaCollectionRequest
extends BaseCollectionRequest<TodoTaskListDeltaCollectionResponse, ITodoTaskListDeltaCollectionPage>
implements ITodoTaskListDeltaCollectionRequest {
    public TodoTaskListDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTaskListDeltaCollectionResponse.class, ITodoTaskListDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITodoTaskListDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TodoTaskListDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITodoTaskListDeltaCollectionPage get() throws ClientException {
        TodoTaskListDeltaCollectionResponse response = (TodoTaskListDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public ITodoTaskListDeltaCollectionPage buildFromResponse(TodoTaskListDeltaCollectionResponse response) {
        TodoTaskListDeltaCollectionRequestBuilder builder = response.nextLink != null ? new TodoTaskListDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TodoTaskListDeltaCollectionPage page = new TodoTaskListDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ITodoTaskListDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITodoTaskListDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITodoTaskListDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ITodoTaskListDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ITodoTaskListDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

