/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AppRoleAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.AppRoleAssignmentCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.AppRoleAssignmentCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IAppRoleAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IAppRoleAssignmentCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IAppRoleAssignmentCollectionWithReferencesRequest;
import java.util.List;

public class AppRoleAssignmentCollectionWithReferencesRequest
extends BaseCollectionRequest<AppRoleAssignmentCollectionResponse, IAppRoleAssignmentCollectionPage>
implements IAppRoleAssignmentCollectionWithReferencesRequest {
    public AppRoleAssignmentCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppRoleAssignmentCollectionResponse.class, IAppRoleAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAppRoleAssignmentCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AppRoleAssignmentCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAppRoleAssignmentCollectionWithReferencesPage get() throws ClientException {
        AppRoleAssignmentCollectionResponse response = (AppRoleAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IAppRoleAssignmentCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IAppRoleAssignmentCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IAppRoleAssignmentCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAppRoleAssignmentCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAppRoleAssignmentCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IAppRoleAssignmentCollectionWithReferencesPage buildFromResponse(AppRoleAssignmentCollectionResponse response) {
        AppRoleAssignmentCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new AppRoleAssignmentCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AppRoleAssignmentCollectionWithReferencesPage page = new AppRoleAssignmentCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

