/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.Prompt;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.CallRecordResponseRequest;
import com.microsoft.graph.requests.extensions.ICallRecordResponseRequest;
import com.microsoft.graph.requests.extensions.ICallRecordResponseRequestBuilder;
import java.util.List;

public class CallRecordResponseRequestBuilder
extends BaseActionRequestBuilder
implements ICallRecordResponseRequestBuilder {
    public CallRecordResponseRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, List<Prompt> prompts, Boolean bargeInAllowed, Integer initialSilenceTimeoutInSeconds, Integer maxSilenceTimeoutInSeconds, Integer maxRecordDurationInSeconds, Boolean playBeep, List<String> stopTones, String clientContext) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("prompts", prompts);
        this.bodyParams.put("bargeInAllowed", bargeInAllowed);
        this.bodyParams.put("initialSilenceTimeoutInSeconds", initialSilenceTimeoutInSeconds);
        this.bodyParams.put("maxSilenceTimeoutInSeconds", maxSilenceTimeoutInSeconds);
        this.bodyParams.put("maxRecordDurationInSeconds", maxRecordDurationInSeconds);
        this.bodyParams.put("playBeep", playBeep);
        this.bodyParams.put("stopTones", stopTones);
        this.bodyParams.put("clientContext", clientContext);
    }

    @Override
    public ICallRecordResponseRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public ICallRecordResponseRequest buildRequest(List<? extends Option> requestOptions) {
        CallRecordResponseRequest request = new CallRecordResponseRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("prompts")) {
            request.body.prompts = (List)this.getParameter("prompts");
        }
        if (this.hasParameter("bargeInAllowed")) {
            request.body.bargeInAllowed = (Boolean)this.getParameter("bargeInAllowed");
        }
        if (this.hasParameter("initialSilenceTimeoutInSeconds")) {
            request.body.initialSilenceTimeoutInSeconds = (Integer)this.getParameter("initialSilenceTimeoutInSeconds");
        }
        if (this.hasParameter("maxSilenceTimeoutInSeconds")) {
            request.body.maxSilenceTimeoutInSeconds = (Integer)this.getParameter("maxSilenceTimeoutInSeconds");
        }
        if (this.hasParameter("maxRecordDurationInSeconds")) {
            request.body.maxRecordDurationInSeconds = (Integer)this.getParameter("maxRecordDurationInSeconds");
        }
        if (this.hasParameter("playBeep")) {
            request.body.playBeep = (Boolean)this.getParameter("playBeep");
        }
        if (this.hasParameter("stopTones")) {
            request.body.stopTones = (List)this.getParameter("stopTones");
        }
        if (this.hasParameter("clientContext")) {
            request.body.clientContext = (String)this.getParameter("clientContext");
        }
        return request;
    }
}

