/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ChatMessage;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IChatMessageRequest;
import java.util.List;

public class ChatMessageRequest
extends BaseRequest
implements IChatMessageRequest {
    public ChatMessageRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatMessage.class);
    }

    @Override
    public void get(ICallback<? super ChatMessage> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ChatMessage get() throws ClientException {
        return (ChatMessage)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super ChatMessage> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ChatMessage sourceChatMessage, ICallback<? super ChatMessage> callback) {
        this.send(HttpMethod.PATCH, callback, sourceChatMessage);
    }

    @Override
    public ChatMessage patch(ChatMessage sourceChatMessage) throws ClientException {
        return (ChatMessage)this.send(HttpMethod.PATCH, sourceChatMessage);
    }

    @Override
    public void post(ChatMessage newChatMessage, ICallback<? super ChatMessage> callback) {
        this.send(HttpMethod.POST, callback, newChatMessage);
    }

    @Override
    public ChatMessage post(ChatMessage newChatMessage) throws ClientException {
        return (ChatMessage)this.send(HttpMethod.POST, newChatMessage);
    }

    @Override
    public void put(ChatMessage newChatMessage, ICallback<? super ChatMessage> callback) {
        this.send(HttpMethod.PUT, callback, newChatMessage);
    }

    @Override
    public ChatMessage put(ChatMessage newChatMessage) throws ClientException {
        return (ChatMessage)this.send(HttpMethod.PUT, newChatMessage);
    }

    @Override
    public IChatMessageRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChatMessageRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

