/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ContactDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.ContactDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactDeltaCollectionResponse;
import com.microsoft.graph.requests.extensions.IContactDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IContactDeltaCollectionRequest;
import java.util.List;

public class ContactDeltaCollectionRequest
extends BaseCollectionRequest<ContactDeltaCollectionResponse, IContactDeltaCollectionPage>
implements IContactDeltaCollectionRequest {
    public ContactDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContactDeltaCollectionResponse.class, IContactDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IContactDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ContactDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContactDeltaCollectionPage get() throws ClientException {
        ContactDeltaCollectionResponse response = (ContactDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IContactDeltaCollectionPage buildFromResponse(ContactDeltaCollectionResponse response) {
        ContactDeltaCollectionRequestBuilder builder = response.nextLink != null ? new ContactDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContactDeltaCollectionPage page = new ContactDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IContactDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IContactDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IContactDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IContactDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IContactDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

