/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DelegatedPermissionClassification;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DelegatedPermissionClassificationCollectionPage;
import com.microsoft.graph.requests.extensions.DelegatedPermissionClassificationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DelegatedPermissionClassificationCollectionResponse;
import com.microsoft.graph.requests.extensions.DelegatedPermissionClassificationRequestBuilder;
import com.microsoft.graph.requests.extensions.IDelegatedPermissionClassificationCollectionPage;
import com.microsoft.graph.requests.extensions.IDelegatedPermissionClassificationCollectionRequest;
import java.util.List;

public class DelegatedPermissionClassificationCollectionRequest
extends BaseCollectionRequest<DelegatedPermissionClassificationCollectionResponse, IDelegatedPermissionClassificationCollectionPage>
implements IDelegatedPermissionClassificationCollectionRequest {
    public DelegatedPermissionClassificationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DelegatedPermissionClassificationCollectionResponse.class, IDelegatedPermissionClassificationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDelegatedPermissionClassificationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DelegatedPermissionClassificationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDelegatedPermissionClassificationCollectionPage get() throws ClientException {
        DelegatedPermissionClassificationCollectionResponse response = (DelegatedPermissionClassificationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DelegatedPermissionClassification newDelegatedPermissionClassification, ICallback<? super DelegatedPermissionClassification> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DelegatedPermissionClassificationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDelegatedPermissionClassification, callback);
    }

    @Override
    public DelegatedPermissionClassification post(DelegatedPermissionClassification newDelegatedPermissionClassification) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DelegatedPermissionClassificationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDelegatedPermissionClassification);
    }

    @Override
    public IDelegatedPermissionClassificationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDelegatedPermissionClassificationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDelegatedPermissionClassificationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDelegatedPermissionClassificationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDelegatedPermissionClassificationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDelegatedPermissionClassificationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDelegatedPermissionClassificationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDelegatedPermissionClassificationCollectionPage buildFromResponse(DelegatedPermissionClassificationCollectionResponse response) {
        DelegatedPermissionClassificationCollectionRequestBuilder builder = response.nextLink != null ? new DelegatedPermissionClassificationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DelegatedPermissionClassificationCollectionPage page = new DelegatedPermissionClassificationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

