/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveSearchCollectionPage;
import com.microsoft.graph.requests.extensions.DriveSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveSearchCollectionResponse;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionRequest;
import java.util.List;

public class DriveSearchCollectionRequest
extends BaseCollectionRequest<DriveSearchCollectionResponse, IDriveSearchCollectionPage>
implements IDriveSearchCollectionRequest {
    public DriveSearchCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveSearchCollectionResponse.class, IDriveSearchCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDriveSearchCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveSearchCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveSearchCollectionPage get() throws ClientException {
        DriveSearchCollectionResponse response = (DriveSearchCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveSearchCollectionPage buildFromResponse(DriveSearchCollectionResponse response) {
        DriveSearchCollectionRequestBuilder builder = response.nextLink != null ? new DriveSearchCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DriveSearchCollectionPage page = new DriveSearchCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveSearchCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveSearchCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveSearchCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IDriveSearchCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IDriveSearchCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

