// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.ContainerImageEvidence;
import com.microsoft.graph.security.models.KubernetesPodEvidence;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Container Evidence.
 */
public class ContainerEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Args.
     * The list of arguments.
     */
    @SerializedName(value = "args", alternate = {"Args"})
    @Expose
	@Nullable
    public java.util.List<String> args;

    /**
     * The Command.
     * The list of commands.
     */
    @SerializedName(value = "command", alternate = {"Command"})
    @Expose
	@Nullable
    public java.util.List<String> command;

    /**
     * The Container Id.
     * The container ID.
     */
    @SerializedName(value = "containerId", alternate = {"ContainerId"})
    @Expose
	@Nullable
    public String containerId;

    /**
     * The Image.
     * The image used to run the container.
     */
    @SerializedName(value = "image", alternate = {"Image"})
    @Expose
	@Nullable
    public ContainerImageEvidence image;

    /**
     * The Is Privileged.
     * The privileged status.
     */
    @SerializedName(value = "isPrivileged", alternate = {"IsPrivileged"})
    @Expose
	@Nullable
    public Boolean isPrivileged;

    /**
     * The Name.
     * The container name.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Pod.
     * The pod this container belongs to.
     */
    @SerializedName(value = "pod", alternate = {"Pod"})
    @Expose
	@Nullable
    public KubernetesPodEvidence pod;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
