/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AppManagementConfiguration;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.PolicyBase;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AppManagementPolicy
extends PolicyBase
implements Parsable {
    public AppManagementPolicy() {
        this.setOdataType("#microsoft.graph.appManagementPolicy");
    }

    @Nonnull
    public static AppManagementPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AppManagementPolicy();
    }

    @Nullable
    public List<DirectoryObject> getAppliesTo() {
        return (List)this.backingStore.get("appliesTo");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appliesTo", n -> this.setAppliesTo(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("isEnabled", n -> this.setIsEnabled(n.getBooleanValue()));
        deserializerMap.put("restrictions", n -> this.setRestrictions((AppManagementConfiguration)n.getObjectValue(AppManagementConfiguration::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsEnabled() {
        return (Boolean)this.backingStore.get("isEnabled");
    }

    @Nullable
    public AppManagementConfiguration getRestrictions() {
        return (AppManagementConfiguration)this.backingStore.get("restrictions");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("appliesTo", this.getAppliesTo());
        writer.writeBooleanValue("isEnabled", this.getIsEnabled());
        writer.writeObjectValue("restrictions", (Parsable)this.getRestrictions(), new Parsable[0]);
    }

    public void setAppliesTo(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("appliesTo", value);
    }

    public void setIsEnabled(@Nullable Boolean value) {
        this.backingStore.set("isEnabled", (Object)value);
    }

    public void setRestrictions(@Nullable AppManagementConfiguration value) {
        this.backingStore.set("restrictions", (Object)value);
    }
}

