/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Initiator;
import com.microsoft.graph.models.ModifiedProperty;
import com.microsoft.graph.models.ProvisionedIdentity;
import com.microsoft.graph.models.ProvisioningAction;
import com.microsoft.graph.models.ProvisioningServicePrincipal;
import com.microsoft.graph.models.ProvisioningStatusInfo;
import com.microsoft.graph.models.ProvisioningStep;
import com.microsoft.graph.models.ProvisioningSystem;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProvisioningObjectSummary
extends Entity
implements Parsable {
    @Nonnull
    public static ProvisioningObjectSummary createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ProvisioningObjectSummary();
    }

    @Nullable
    public OffsetDateTime getActivityDateTime() {
        return (OffsetDateTime)this.backingStore.get("activityDateTime");
    }

    @Nullable
    public String getChangeId() {
        return (String)this.backingStore.get("changeId");
    }

    @Nullable
    public String getCycleId() {
        return (String)this.backingStore.get("cycleId");
    }

    @Nullable
    public Integer getDurationInMilliseconds() {
        return (Integer)this.backingStore.get("durationInMilliseconds");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activityDateTime", n -> this.setActivityDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("changeId", n -> this.setChangeId(n.getStringValue()));
        deserializerMap.put("cycleId", n -> this.setCycleId(n.getStringValue()));
        deserializerMap.put("durationInMilliseconds", n -> this.setDurationInMilliseconds(n.getIntegerValue()));
        deserializerMap.put("initiatedBy", n -> this.setInitiatedBy((Initiator)n.getObjectValue(Initiator::createFromDiscriminatorValue)));
        deserializerMap.put("jobId", n -> this.setJobId(n.getStringValue()));
        deserializerMap.put("modifiedProperties", n -> this.setModifiedProperties(n.getCollectionOfObjectValues(ModifiedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("provisioningAction", n -> this.setProvisioningAction((ProvisioningAction)n.getEnumValue(ProvisioningAction::forValue)));
        deserializerMap.put("provisioningStatusInfo", n -> this.setProvisioningStatusInfo((ProvisioningStatusInfo)n.getObjectValue(ProvisioningStatusInfo::createFromDiscriminatorValue)));
        deserializerMap.put("provisioningSteps", n -> this.setProvisioningSteps(n.getCollectionOfObjectValues(ProvisioningStep::createFromDiscriminatorValue)));
        deserializerMap.put("servicePrincipal", n -> this.setServicePrincipal((ProvisioningServicePrincipal)n.getObjectValue(ProvisioningServicePrincipal::createFromDiscriminatorValue)));
        deserializerMap.put("sourceIdentity", n -> this.setSourceIdentity((ProvisionedIdentity)n.getObjectValue(ProvisionedIdentity::createFromDiscriminatorValue)));
        deserializerMap.put("sourceSystem", n -> this.setSourceSystem((ProvisioningSystem)n.getObjectValue(ProvisioningSystem::createFromDiscriminatorValue)));
        deserializerMap.put("targetIdentity", n -> this.setTargetIdentity((ProvisionedIdentity)n.getObjectValue(ProvisionedIdentity::createFromDiscriminatorValue)));
        deserializerMap.put("targetSystem", n -> this.setTargetSystem((ProvisioningSystem)n.getObjectValue(ProvisioningSystem::createFromDiscriminatorValue)));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Initiator getInitiatedBy() {
        return (Initiator)this.backingStore.get("initiatedBy");
    }

    @Nullable
    public String getJobId() {
        return (String)this.backingStore.get("jobId");
    }

    @Nullable
    public List<ModifiedProperty> getModifiedProperties() {
        return (List)this.backingStore.get("modifiedProperties");
    }

    @Nullable
    public ProvisioningAction getProvisioningAction() {
        return (ProvisioningAction)((Object)this.backingStore.get("provisioningAction"));
    }

    @Nullable
    public ProvisioningStatusInfo getProvisioningStatusInfo() {
        return (ProvisioningStatusInfo)this.backingStore.get("provisioningStatusInfo");
    }

    @Nullable
    public List<ProvisioningStep> getProvisioningSteps() {
        return (List)this.backingStore.get("provisioningSteps");
    }

    @Nullable
    public ProvisioningServicePrincipal getServicePrincipal() {
        return (ProvisioningServicePrincipal)this.backingStore.get("servicePrincipal");
    }

    @Nullable
    public ProvisionedIdentity getSourceIdentity() {
        return (ProvisionedIdentity)this.backingStore.get("sourceIdentity");
    }

    @Nullable
    public ProvisioningSystem getSourceSystem() {
        return (ProvisioningSystem)this.backingStore.get("sourceSystem");
    }

    @Nullable
    public ProvisionedIdentity getTargetIdentity() {
        return (ProvisionedIdentity)this.backingStore.get("targetIdentity");
    }

    @Nullable
    public ProvisioningSystem getTargetSystem() {
        return (ProvisioningSystem)this.backingStore.get("targetSystem");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("activityDateTime", this.getActivityDateTime());
        writer.writeStringValue("changeId", this.getChangeId());
        writer.writeStringValue("cycleId", this.getCycleId());
        writer.writeIntegerValue("durationInMilliseconds", this.getDurationInMilliseconds());
        writer.writeObjectValue("initiatedBy", (Parsable)this.getInitiatedBy(), new Parsable[0]);
        writer.writeStringValue("jobId", this.getJobId());
        writer.writeCollectionOfObjectValues("modifiedProperties", this.getModifiedProperties());
        writer.writeEnumValue("provisioningAction", (Enum)this.getProvisioningAction());
        writer.writeObjectValue("provisioningStatusInfo", (Parsable)this.getProvisioningStatusInfo(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("provisioningSteps", this.getProvisioningSteps());
        writer.writeObjectValue("servicePrincipal", (Parsable)this.getServicePrincipal(), new Parsable[0]);
        writer.writeObjectValue("sourceIdentity", (Parsable)this.getSourceIdentity(), new Parsable[0]);
        writer.writeObjectValue("sourceSystem", (Parsable)this.getSourceSystem(), new Parsable[0]);
        writer.writeObjectValue("targetIdentity", (Parsable)this.getTargetIdentity(), new Parsable[0]);
        writer.writeObjectValue("targetSystem", (Parsable)this.getTargetSystem(), new Parsable[0]);
        writer.writeStringValue("tenantId", this.getTenantId());
    }

    public void setActivityDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("activityDateTime", (Object)value);
    }

    public void setChangeId(@Nullable String value) {
        this.backingStore.set("changeId", (Object)value);
    }

    public void setCycleId(@Nullable String value) {
        this.backingStore.set("cycleId", (Object)value);
    }

    public void setDurationInMilliseconds(@Nullable Integer value) {
        this.backingStore.set("durationInMilliseconds", (Object)value);
    }

    public void setInitiatedBy(@Nullable Initiator value) {
        this.backingStore.set("initiatedBy", (Object)value);
    }

    public void setJobId(@Nullable String value) {
        this.backingStore.set("jobId", (Object)value);
    }

    public void setModifiedProperties(@Nullable List<ModifiedProperty> value) {
        this.backingStore.set("modifiedProperties", value);
    }

    public void setProvisioningAction(@Nullable ProvisioningAction value) {
        this.backingStore.set("provisioningAction", (Object)value);
    }

    public void setProvisioningStatusInfo(@Nullable ProvisioningStatusInfo value) {
        this.backingStore.set("provisioningStatusInfo", (Object)value);
    }

    public void setProvisioningSteps(@Nullable List<ProvisioningStep> value) {
        this.backingStore.set("provisioningSteps", value);
    }

    public void setServicePrincipal(@Nullable ProvisioningServicePrincipal value) {
        this.backingStore.set("servicePrincipal", (Object)value);
    }

    public void setSourceIdentity(@Nullable ProvisionedIdentity value) {
        this.backingStore.set("sourceIdentity", (Object)value);
    }

    public void setSourceSystem(@Nullable ProvisioningSystem value) {
        this.backingStore.set("sourceSystem", (Object)value);
    }

    public void setTargetIdentity(@Nullable ProvisionedIdentity value) {
        this.backingStore.set("targetIdentity", (Object)value);
    }

    public void setTargetSystem(@Nullable ProvisioningSystem value) {
        this.backingStore.set("targetSystem", (Object)value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }
}

