/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChangeTrackedEntity;
import com.microsoft.graph.models.OfferShiftRequest;
import com.microsoft.graph.models.OpenShiftChangeRequest;
import com.microsoft.graph.models.ScheduleChangeRequestActor;
import com.microsoft.graph.models.ScheduleChangeState;
import com.microsoft.graph.models.SwapShiftsChangeRequest;
import com.microsoft.graph.models.TimeOffRequest;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ScheduleChangeRequest
extends ChangeTrackedEntity
implements Parsable {
    public ScheduleChangeRequest() {
        this.setOdataType("#microsoft.graph.scheduleChangeRequest");
    }

    @Nonnull
    public static ScheduleChangeRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.offerShiftRequest": {
                    return new OfferShiftRequest();
                }
                case "#microsoft.graph.openShiftChangeRequest": {
                    return new OpenShiftChangeRequest();
                }
                case "#microsoft.graph.swapShiftsChangeRequest": {
                    return new SwapShiftsChangeRequest();
                }
                case "#microsoft.graph.timeOffRequest": {
                    return new TimeOffRequest();
                }
            }
        }
        return new ScheduleChangeRequest();
    }

    @Nullable
    public ScheduleChangeRequestActor getAssignedTo() {
        return (ScheduleChangeRequestActor)((Object)this.backingStore.get("assignedTo"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignedTo", n -> this.setAssignedTo((ScheduleChangeRequestActor)n.getEnumValue(ScheduleChangeRequestActor::forValue)));
        deserializerMap.put("managerActionDateTime", n -> this.setManagerActionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("managerActionMessage", n -> this.setManagerActionMessage(n.getStringValue()));
        deserializerMap.put("managerUserId", n -> this.setManagerUserId(n.getStringValue()));
        deserializerMap.put("senderDateTime", n -> this.setSenderDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("senderMessage", n -> this.setSenderMessage(n.getStringValue()));
        deserializerMap.put("senderUserId", n -> this.setSenderUserId(n.getStringValue()));
        deserializerMap.put("state", n -> this.setState((ScheduleChangeState)n.getEnumValue(ScheduleChangeState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getManagerActionDateTime() {
        return (OffsetDateTime)this.backingStore.get("managerActionDateTime");
    }

    @Nullable
    public String getManagerActionMessage() {
        return (String)this.backingStore.get("managerActionMessage");
    }

    @Nullable
    public String getManagerUserId() {
        return (String)this.backingStore.get("managerUserId");
    }

    @Nullable
    public OffsetDateTime getSenderDateTime() {
        return (OffsetDateTime)this.backingStore.get("senderDateTime");
    }

    @Nullable
    public String getSenderMessage() {
        return (String)this.backingStore.get("senderMessage");
    }

    @Nullable
    public String getSenderUserId() {
        return (String)this.backingStore.get("senderUserId");
    }

    @Nullable
    public ScheduleChangeState getState() {
        return (ScheduleChangeState)((Object)this.backingStore.get("state"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("assignedTo", (Enum)this.getAssignedTo());
        writer.writeStringValue("managerActionMessage", this.getManagerActionMessage());
        writer.writeStringValue("senderMessage", this.getSenderMessage());
        writer.writeEnumValue("state", (Enum)this.getState());
    }

    public void setAssignedTo(@Nullable ScheduleChangeRequestActor value) {
        this.backingStore.set("assignedTo", (Object)value);
    }

    public void setManagerActionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("managerActionDateTime", (Object)value);
    }

    public void setManagerActionMessage(@Nullable String value) {
        this.backingStore.set("managerActionMessage", (Object)value);
    }

    public void setManagerUserId(@Nullable String value) {
        this.backingStore.set("managerUserId", (Object)value);
    }

    public void setSenderDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("senderDateTime", (Object)value);
    }

    public void setSenderMessage(@Nullable String value) {
        this.backingStore.set("senderMessage", (Object)value);
    }

    public void setSenderUserId(@Nullable String value) {
        this.backingStore.set("senderUserId", (Object)value);
    }

    public void setState(@Nullable ScheduleChangeState value) {
        this.backingStore.set("state", (Object)value);
    }
}

