/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SearchAggregation;
import com.microsoft.graph.models.SearchHit;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SearchHitsContainer
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SearchHitsContainer() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SearchHitsContainer createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SearchHitsContainer();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<SearchAggregation> getAggregations() {
        return (List)this.backingStore.get("aggregations");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("aggregations", n -> this.setAggregations(n.getCollectionOfObjectValues(SearchAggregation::createFromDiscriminatorValue)));
        deserializerMap.put("hits", n -> this.setHits(n.getCollectionOfObjectValues(SearchHit::createFromDiscriminatorValue)));
        deserializerMap.put("moreResultsAvailable", n -> this.setMoreResultsAvailable(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("total", n -> this.setTotal(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public List<SearchHit> getHits() {
        return (List)this.backingStore.get("hits");
    }

    @Nullable
    public Boolean getMoreResultsAvailable() {
        return (Boolean)this.backingStore.get("moreResultsAvailable");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getTotal() {
        return (Integer)this.backingStore.get("total");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("aggregations", this.getAggregations());
        writer.writeCollectionOfObjectValues("hits", this.getHits());
        writer.writeBooleanValue("moreResultsAvailable", this.getMoreResultsAvailable());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("total", this.getTotal());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAggregations(@Nullable List<SearchAggregation> value) {
        this.backingStore.set("aggregations", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setHits(@Nullable List<SearchHit> value) {
        this.backingStore.set("hits", value);
    }

    public void setMoreResultsAvailable(@Nullable Boolean value) {
        this.backingStore.set("moreResultsAvailable", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setTotal(@Nullable Integer value) {
        this.backingStore.set("total", (Object)value);
    }
}

