/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IdentitySet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SharingInvitation
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SharingInvitation() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SharingInvitation createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SharingInvitation();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getEmail() {
        return (String)this.backingStore.get("email");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("email", n -> this.setEmail(n.getStringValue()));
        deserializerMap.put("invitedBy", n -> this.setInvitedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("redeemedBy", n -> this.setRedeemedBy(n.getStringValue()));
        deserializerMap.put("signInRequired", n -> this.setSignInRequired(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getInvitedBy() {
        return (IdentitySet)this.backingStore.get("invitedBy");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getRedeemedBy() {
        return (String)this.backingStore.get("redeemedBy");
    }

    @Nullable
    public Boolean getSignInRequired() {
        return (Boolean)this.backingStore.get("signInRequired");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("email", this.getEmail());
        writer.writeObjectValue("invitedBy", (Parsable)this.getInvitedBy(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("redeemedBy", this.getRedeemedBy());
        writer.writeBooleanValue("signInRequired", this.getSignInRequired());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEmail(@Nullable String value) {
        this.backingStore.set("email", (Object)value);
    }

    public void setInvitedBy(@Nullable IdentitySet value) {
        this.backingStore.set("invitedBy", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRedeemedBy(@Nullable String value) {
        this.backingStore.set("redeemedBy", (Object)value);
    }

    public void setSignInRequired(@Nullable Boolean value) {
        this.backingStore.set("signInRequired", (Object)value);
    }
}

