/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.callrecords;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.callrecords.CallType;
import com.microsoft.graph.models.callrecords.Modality;
import com.microsoft.graph.models.callrecords.Session;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CallRecord
extends Entity
implements Parsable {
    @Nonnull
    public static CallRecord createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CallRecord();
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("joinWebUrl", n -> this.setJoinWebUrl(n.getStringValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("modalities", n -> this.setModalities(n.getCollectionOfEnumValues(Modality::forValue)));
        deserializerMap.put("organizer", n -> this.setOrganizer((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("participants", n -> this.setParticipants(n.getCollectionOfObjectValues(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("sessions", n -> this.setSessions(n.getCollectionOfObjectValues(Session::createFromDiscriminatorValue)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("type", n -> this.setType((CallType)n.getEnumValue(CallType::forValue)));
        deserializerMap.put("version", n -> this.setVersion(n.getLongValue()));
        return deserializerMap;
    }

    @Nullable
    public String getJoinWebUrl() {
        return (String)this.backingStore.get("joinWebUrl");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<Modality> getModalities() {
        return (List)this.backingStore.get("modalities");
    }

    @Nullable
    public IdentitySet getOrganizer() {
        return (IdentitySet)this.backingStore.get("organizer");
    }

    @Nullable
    public List<IdentitySet> getParticipants() {
        return (List)this.backingStore.get("participants");
    }

    @Nullable
    public List<Session> getSessions() {
        return (List)this.backingStore.get("sessions");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public CallType getType() {
        return (CallType)((Object)this.backingStore.get("type"));
    }

    @Nullable
    public Long getVersion() {
        return (Long)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeStringValue("joinWebUrl", this.getJoinWebUrl());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfEnumValues("modalities", this.getModalities());
        writer.writeObjectValue("organizer", (Parsable)this.getOrganizer(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("participants", this.getParticipants());
        writer.writeCollectionOfObjectValues("sessions", this.getSessions());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeEnumValue("type", (Enum)this.getType());
        writer.writeLongValue("version", this.getVersion());
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setJoinWebUrl(@Nullable String value) {
        this.backingStore.set("joinWebUrl", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setModalities(@Nullable List<Modality> value) {
        this.backingStore.set("modalities", value);
    }

    public void setOrganizer(@Nullable IdentitySet value) {
        this.backingStore.set("organizer", (Object)value);
    }

    public void setParticipants(@Nullable List<IdentitySet> value) {
        this.backingStore.set("participants", value);
    }

    public void setSessions(@Nullable List<Session> value) {
        this.backingStore.set("sessions", value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setType(@Nullable CallType value) {
        this.backingStore.set("type", (Object)value);
    }

    public void setVersion(@Nullable Long value) {
        this.backingStore.set("version", (Object)value);
    }
}

