/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.sites.item;

import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.sites.item.analytics.AnalyticsRequestBuilder;
import com.microsoft.graph.sites.item.columns.ColumnsRequestBuilder;
import com.microsoft.graph.sites.item.contenttypes.ContentTypesRequestBuilder;
import com.microsoft.graph.sites.item.createdbyuser.CreatedByUserRequestBuilder;
import com.microsoft.graph.sites.item.drive.DriveRequestBuilder;
import com.microsoft.graph.sites.item.drives.DrivesRequestBuilder;
import com.microsoft.graph.sites.item.externalcolumns.ExternalColumnsRequestBuilder;
import com.microsoft.graph.sites.item.getactivitiesbyinterval.GetActivitiesByIntervalRequestBuilder;
import com.microsoft.graph.sites.item.getactivitiesbyintervalwithstartdatetimewithenddatetimewithinterval.GetActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithIntervalRequestBuilder;
import com.microsoft.graph.sites.item.getapplicablecontenttypesforlistwithlistid.GetApplicableContentTypesForListWithListIdRequestBuilder;
import com.microsoft.graph.sites.item.getbypathwithpath.GetByPathWithPathRequestBuilder;
import com.microsoft.graph.sites.item.items.ItemsRequestBuilder;
import com.microsoft.graph.sites.item.lastmodifiedbyuser.LastModifiedByUserRequestBuilder;
import com.microsoft.graph.sites.item.lists.ListsRequestBuilder;
import com.microsoft.graph.sites.item.onenote.OnenoteRequestBuilder;
import com.microsoft.graph.sites.item.operations.OperationsRequestBuilder;
import com.microsoft.graph.sites.item.pages.PagesRequestBuilder;
import com.microsoft.graph.sites.item.permissions.PermissionsRequestBuilder;
import com.microsoft.graph.sites.item.sites.SitesRequestBuilder;
import com.microsoft.graph.sites.item.termstore.TermStoreRequestBuilder;
import com.microsoft.graph.sites.item.termstores.TermStoresRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SiteItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AnalyticsRequestBuilder analytics() {
        return new AnalyticsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ColumnsRequestBuilder columns() {
        return new ColumnsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ContentTypesRequestBuilder contentTypes() {
        return new ContentTypesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreatedByUserRequestBuilder createdByUser() {
        return new CreatedByUserRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DriveRequestBuilder drive() {
        return new DriveRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DrivesRequestBuilder drives() {
        return new DrivesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ExternalColumnsRequestBuilder externalColumns() {
        return new ExternalColumnsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GetActivitiesByIntervalRequestBuilder getActivitiesByInterval() {
        return new GetActivitiesByIntervalRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ItemsRequestBuilder items() {
        return new ItemsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LastModifiedByUserRequestBuilder lastModifiedByUser() {
        return new LastModifiedByUserRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ListsRequestBuilder lists() {
        return new ListsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OnenoteRequestBuilder onenote() {
        return new OnenoteRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OperationsRequestBuilder operations() {
        return new OperationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PagesRequestBuilder pages() {
        return new PagesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PermissionsRequestBuilder permissions() {
        return new PermissionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SitesRequestBuilder sites() {
        return new SitesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TermStoreRequestBuilder termStore() {
        return new TermStoreRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TermStoresRequestBuilder termStores() {
        return new TermStoresRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public SiteItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/sites/{site%2Did}{?%24expand,%24select}", pathParameters);
    }

    public SiteItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/sites/{site%2Did}{?%24expand,%24select}", rawUrl);
    }

    @Nullable
    public Site get() {
        return this.get(null);
    }

    @Nullable
    public Site get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Site)this.requestAdapter.send(requestInfo, errorMapping, Site::createFromDiscriminatorValue);
    }

    @Nonnull
    public GetActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithIntervalRequestBuilder getActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithInterval(@Nonnull String endDateTime, @Nonnull String interval, @Nonnull String startDateTime) {
        Objects.requireNonNull(endDateTime);
        Objects.requireNonNull(interval);
        Objects.requireNonNull(startDateTime);
        return new GetActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithIntervalRequestBuilder(this.pathParameters, this.requestAdapter, endDateTime, interval, startDateTime);
    }

    @Nonnull
    public GetApplicableContentTypesForListWithListIdRequestBuilder getApplicableContentTypesForListWithListId(@Nonnull String listId) {
        Objects.requireNonNull(listId);
        return new GetApplicableContentTypesForListWithListIdRequestBuilder(this.pathParameters, this.requestAdapter, listId);
    }

    @Nonnull
    public GetByPathWithPathRequestBuilder getByPathWithPath(@Nonnull String path) {
        Objects.requireNonNull(path);
        return new GetByPathWithPathRequestBuilder(this.pathParameters, this.requestAdapter, path);
    }

    @Nullable
    public Site patch(@Nonnull Site body) {
        return this.patch(body, null);
    }

    @Nullable
    public Site patch(@Nonnull Site body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Site)this.requestAdapter.send(requestInfo, errorMapping, Site::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Site body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Site body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public SiteItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new SiteItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

