/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.MultipartBody;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.ResponseHandlerOption;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.ValuedEnum;
import io.github.stduritemplate.StdUriTemplate;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class RequestInformation {
    @Nullable
    public String urlTemplate;
    @Nullable
    public Map<String, Object> pathParameters = new HashMap<String, Object>();
    private URI uri;
    static final String RAW_URL_KEY = "request-raw-url";
    @Nullable
    public HttpMethod httpMethod;
    private HashMap<String, Object> queryParameters = new HashMap();
    @Nonnull
    public final RequestHeaders headers = new RequestHeaders();
    @Nullable
    public InputStream content;
    @Nonnull
    private final HashMap<String, RequestOption> requestOptions = new HashMap();
    @Nonnull
    private static final String BINARY_CONTENT_TYPE = "application/octet-stream";
    @Nonnull
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String SERIALIZE_ERROR = "could not serialize payload";
    private static final String SPAN_NAME = "setContentFromParsable";
    private static final String OBSERVABILITY_TRACER_NAME = "com.microsoft.kiota";

    public RequestInformation() {
    }

    public RequestInformation(@Nonnull HttpMethod method, @Nonnull String urlTemplate, @Nonnull Map<String, Object> pathParameters) {
        this.httpMethod = Objects.requireNonNull(method);
        this.urlTemplate = Objects.requireNonNull(urlTemplate);
        this.pathParameters = Objects.requireNonNull(pathParameters);
    }

    public <T extends BaseRequestConfiguration> void configure(@Nullable Consumer<T> requestConfiguration, @Nonnull Supplier<T> configurationFactory) {
        this.configure(requestConfiguration, configurationFactory, null);
    }

    public <T extends BaseRequestConfiguration> void configure(@Nullable Consumer<T> requestConfiguration, @Nonnull Supplier<T> configurationFactory, @Nullable Function<T, QueryParameters> queryParametersGetter) {
        Objects.requireNonNull(configurationFactory);
        if (requestConfiguration == null) {
            return;
        }
        BaseRequestConfiguration requestConfig = (BaseRequestConfiguration)configurationFactory.get();
        requestConfiguration.accept(requestConfig);
        if (queryParametersGetter != null) {
            this.addQueryParameters(queryParametersGetter.apply(requestConfig));
        }
        this.headers.putAll(requestConfig.headers);
        this.addRequestOptions(requestConfig.options);
    }

    @Nullable
    public URI getUri() throws URISyntaxException, IllegalStateException {
        if (this.uri != null) {
            return this.uri;
        }
        if (this.pathParameters.containsKey(RAW_URL_KEY) && this.pathParameters.get(RAW_URL_KEY) instanceof String) {
            this.setUri(new URI((String)this.pathParameters.get(RAW_URL_KEY)));
            return this.uri;
        }
        Objects.requireNonNull(this.urlTemplate);
        Objects.requireNonNull(this.queryParameters);
        if (!this.pathParameters.containsKey("baseurl") && this.urlTemplate.toLowerCase(Locale.ROOT).contains("{+baseurl}")) {
            throw new IllegalStateException("PathParameters must contain a value for \"baseurl\" for the url to be built.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(this.pathParameters.size() + this.queryParameters.size());
        for (Map.Entry<String, Object> pathParam : this.pathParameters.entrySet()) {
            params.put(pathParam.getKey(), RequestInformation.getSanitizedValues(pathParam.getValue()));
        }
        params.putAll(this.queryParameters);
        return new URI(StdUriTemplate.expand((String)this.urlTemplate, params));
    }

    public void setUri(@Nonnull URI uri) {
        this.uri = Objects.requireNonNull(uri);
        if (this.queryParameters != null) {
            this.queryParameters.clear();
        }
        if (this.pathParameters != null) {
            this.pathParameters.clear();
        }
    }

    public void addQueryParameters(@Nullable QueryParameters parameters) {
        if (parameters == null) {
            return;
        }
        Map<String, Object> params = parameters.toQueryParameters();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            if (entry.getKey() == null || entry.getValue() == null || (value = entry.getValue()) == null) continue;
            this.queryParameters.put(entry.getKey(), RequestInformation.getSanitizedValues(value));
        }
    }

    public void addQueryParameter(@Nonnull String name, @Nullable Object value) {
        Objects.requireNonNull(name);
        this.queryParameters.put(name, RequestInformation.getSanitizedValues(value));
    }

    public void removeQueryParameter(@Nonnull String name) {
        Objects.requireNonNull(name);
        this.queryParameters.remove(name);
    }

    @Nonnull
    public Map<String, Object> getQueryParameters() {
        return (Map)this.queryParameters.clone();
    }

    @Nonnull
    public Collection<RequestOption> getRequestOptions() {
        return this.requestOptions.values();
    }

    public void addRequestOptions(@Nullable Collection<RequestOption> options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        for (RequestOption option : options) {
            this.requestOptions.put(option.getClass().getCanonicalName(), option);
        }
    }

    public void removeRequestOptions(RequestOption ... options) {
        if (options == null || options.length == 0) {
            return;
        }
        for (RequestOption option : options) {
            this.requestOptions.remove(option.getClass().getCanonicalName());
        }
    }

    public void setResponseHandler(@Nonnull ResponseHandler responseHandler) {
        Objects.requireNonNull(responseHandler);
        ResponseHandlerOption handlerOption = new ResponseHandlerOption();
        handlerOption.setResponseHandler(responseHandler);
        this.addRequestOptions(new ArrayList<RequestOption>(Arrays.asList(handlerOption)));
    }

    @Deprecated
    public void setStreamContent(@Nonnull InputStream value) {
        this.setStreamContent(value, BINARY_CONTENT_TYPE);
    }

    public void setStreamContent(@Nonnull InputStream value, @Nonnull String contentType) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(contentType);
        if (contentType.isEmpty()) {
            throw new IllegalArgumentException("contentType cannot be empty");
        }
        this.content = value;
        this.headers.tryAdd(CONTENT_TYPE_HEADER, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Parsable> void setContentFromParsable(@Nonnull RequestAdapter requestAdapter, @Nonnull String contentType, @Nonnull T[] values) {
        Span span = GlobalOpenTelemetry.getTracer((String)OBSERVABILITY_TRACER_NAME).spanBuilder(SPAN_NAME).startSpan();
        try (Scope scope = span.makeCurrent();){
            try (SerializationWriter writer = this.getSerializationWriter(requestAdapter, contentType, values);){
                this.headers.tryAdd(CONTENT_TYPE_HEADER, contentType);
                if (values.length > 0) {
                    this.setRequestType(values[0], span);
                }
                writer.writeCollectionOfObjectValues(null, Arrays.asList(values));
                this.content = writer.getSerializedContent();
            }
            catch (IOException ex) {
                RuntimeException result = new RuntimeException(SERIALIZE_ERROR, ex);
                span.recordException((Throwable)result);
                throw result;
            }
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Parsable> void setContentFromParsable(@Nonnull RequestAdapter requestAdapter, @Nonnull String contentType, @Nonnull T value) {
        Span span = GlobalOpenTelemetry.getTracer((String)OBSERVABILITY_TRACER_NAME).spanBuilder(SPAN_NAME).startSpan();
        try (Scope scope = span.makeCurrent();){
            try (SerializationWriter writer = this.getSerializationWriter(requestAdapter, contentType, value);){
                String effectiveContentType = contentType;
                if (value instanceof MultipartBody) {
                    MultipartBody multipartBody = (MultipartBody)value;
                    effectiveContentType = effectiveContentType + "; boundary=" + multipartBody.getBoundary();
                    multipartBody.requestAdapter = requestAdapter;
                }
                this.headers.tryAdd(CONTENT_TYPE_HEADER, effectiveContentType);
                this.setRequestType(value, span);
                writer.writeObjectValue(null, value, new Parsable[0]);
                this.content = writer.getSerializedContent();
            }
            catch (IOException ex) {
                RuntimeException result = new RuntimeException(SERIALIZE_ERROR, ex);
                span.recordException((Throwable)result);
                throw result;
            }
        }
        finally {
            span.end();
        }
    }

    private void setRequestType(Object result, Span span) {
        if (result == null) {
            return;
        }
        if (span == null) {
            return;
        }
        span.setAttribute("com.microsoft.kiota.request.type", result.getClass().getName());
    }

    private <T> SerializationWriter getSerializationWriter(@Nonnull RequestAdapter requestAdapter, @Nonnull String contentType, @Nonnull T value) {
        Objects.requireNonNull(requestAdapter);
        Objects.requireNonNull(value);
        Objects.requireNonNull(contentType);
        return requestAdapter.getSerializationWriterFactory().getSerializationWriter(contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setContentFromScalar(@Nonnull RequestAdapter requestAdapter, @Nonnull String contentType, @Nonnull T value) {
        Span span = GlobalOpenTelemetry.getTracer((String)OBSERVABILITY_TRACER_NAME).spanBuilder(SPAN_NAME).startSpan();
        try (Scope scope = span.makeCurrent();){
            try (SerializationWriter writer = this.getSerializationWriter(requestAdapter, contentType, value);){
                this.headers.tryAdd(CONTENT_TYPE_HEADER, contentType);
                this.setRequestType(value, span);
                Class<?> valueClass = value.getClass();
                if (valueClass.equals(String.class)) {
                    writer.writeStringValue(null, (String)value);
                } else if (valueClass.equals(Boolean.class)) {
                    writer.writeBooleanValue(null, (Boolean)value);
                } else if (valueClass.equals(Byte.class)) {
                    writer.writeByteValue(null, (Byte)value);
                } else if (valueClass.equals(Short.class)) {
                    writer.writeShortValue(null, (Short)value);
                } else if (valueClass.equals(BigDecimal.class)) {
                    writer.writeBigDecimalValue(null, (BigDecimal)value);
                } else if (valueClass.equals(Float.class)) {
                    writer.writeFloatValue(null, (Float)value);
                } else if (valueClass.equals(Long.class)) {
                    writer.writeLongValue(null, (Long)value);
                } else if (valueClass.equals(Integer.class)) {
                    writer.writeIntegerValue(null, (Integer)value);
                } else if (valueClass.equals(UUID.class)) {
                    writer.writeUUIDValue(null, (UUID)value);
                } else if (valueClass.equals(OffsetDateTime.class)) {
                    writer.writeOffsetDateTimeValue(null, (OffsetDateTime)value);
                } else if (valueClass.equals(LocalDate.class)) {
                    writer.writeLocalDateValue(null, (LocalDate)value);
                } else if (valueClass.equals(LocalTime.class)) {
                    writer.writeLocalTimeValue(null, (LocalTime)value);
                } else if (valueClass.equals(PeriodAndDuration.class)) {
                    writer.writePeriodAndDurationValue(null, (PeriodAndDuration)value);
                } else {
                    RuntimeException result = new RuntimeException("unknown type to serialize " + valueClass.getName());
                    span.recordException((Throwable)result);
                    throw result;
                }
                this.content = writer.getSerializedContent();
            }
            catch (IOException ex) {
                RuntimeException result = new RuntimeException(SERIALIZE_ERROR, ex);
                span.recordException((Throwable)result);
                throw result;
            }
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setContentFromScalarCollection(@Nonnull RequestAdapter requestAdapter, @Nonnull String contentType, @Nonnull T[] values) {
        Span span = GlobalOpenTelemetry.getTracer((String)OBSERVABILITY_TRACER_NAME).spanBuilder(SPAN_NAME).startSpan();
        try (Scope scope = span.makeCurrent();){
            try (SerializationWriter writer = this.getSerializationWriter(requestAdapter, contentType, values);){
                this.headers.tryAdd(CONTENT_TYPE_HEADER, contentType);
                if (values.length > 0) {
                    this.setRequestType(values[0], span);
                }
                writer.writeCollectionOfPrimitiveValues(null, Arrays.asList(values));
                this.content = writer.getSerializedContent();
            }
            catch (IOException ex) {
                RuntimeException result = new RuntimeException(SERIALIZE_ERROR, ex);
                span.recordException((Throwable)result);
                throw result;
            }
        }
        finally {
            span.end();
        }
    }

    private static Object getSanitizedValues(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            if (values.length > 0) {
                if (values[0].getClass().isArray()) {
                    throw new IllegalArgumentException("multidimensional arrays are not supported");
                }
                ArrayList<String> result = new ArrayList<String>();
                for (Object item : values) {
                    result.add(RequestInformation.getSanitizedValues(item).toString());
                }
                return result;
            }
            return Arrays.asList(values);
        }
        if (value instanceof ValuedEnum) {
            return ((ValuedEnum)value).getValue();
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        if (value instanceof LocalTime) {
            return ((LocalTime)value).format(DateTimeFormatter.ISO_LOCAL_TIME);
        }
        if (value instanceof PeriodAndDuration) {
            return ((PeriodAndDuration)value).toString();
        }
        return value;
    }
}

