/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http;

import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.ResponseHeaders;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import okhttp3.Headers;

public class HeadersCompatibility {
    private HeadersCompatibility() {
    }

    @Nonnull
    public static ResponseHeaders getResponseHeaders(@Nonnull Headers headers) {
        Objects.requireNonNull(headers);
        ResponseHeaders responseHeaders = new ResponseHeaders();
        headers.toMultimap().forEach((name, value) -> {
            Objects.requireNonNull(name);
            responseHeaders.put(name, new HashSet(value));
        });
        return responseHeaders;
    }

    @Nonnull
    public static RequestHeaders getRequestHeaders(@Nonnull Headers headers) {
        Objects.requireNonNull(headers);
        RequestHeaders requestHeaders = new RequestHeaders();
        headers.toMultimap().forEach((name, value) -> {
            Objects.requireNonNull(name);
            requestHeaders.put(name, new HashSet(value));
        });
        return requestHeaders;
    }
}

