/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.DefaultGsonBuilder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.UntypedArray;
import com.microsoft.kiota.serialization.UntypedBoolean;
import com.microsoft.kiota.serialization.UntypedDouble;
import com.microsoft.kiota.serialization.UntypedNode;
import com.microsoft.kiota.serialization.UntypedNull;
import com.microsoft.kiota.serialization.UntypedObject;
import com.microsoft.kiota.serialization.UntypedString;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class JsonParseNode
implements ParseNode {
    private final JsonElement currentNode;
    private final Gson gson;
    private Consumer<Parsable> onBeforeAssignFieldValues;
    private Consumer<Parsable> onAfterAssignFieldValues;

    public JsonParseNode(@Nonnull JsonElement node) {
        this(node, DefaultGsonBuilder.getDefaultInstance());
    }

    public JsonParseNode(@Nonnull JsonElement node, @Nonnull Gson gson) {
        this.currentNode = Objects.requireNonNull(node, "parameter node cannot be null");
        this.gson = Objects.requireNonNull(gson, "parameter gson cannot be null");
    }

    @Nonnull
    private JsonParseNode createNewNode(@Nonnull JsonElement node) {
        return new JsonParseNode(node, this.gson);
    }

    @Nullable
    public ParseNode getChildNode(@Nonnull String identifier) {
        Objects.requireNonNull(identifier, "identifier parameter is required");
        if (this.currentNode.isJsonObject()) {
            JsonObject object = this.currentNode.getAsJsonObject();
            JsonElement childNodeElement = object.get(identifier);
            if (childNodeElement == null) {
                return null;
            }
            JsonParseNode result = this.createNewNode(childNodeElement);
            result.setOnBeforeAssignFieldValues(this.onBeforeAssignFieldValues);
            result.setOnAfterAssignFieldValues(this.onAfterAssignFieldValues);
            return result;
        }
        return null;
    }

    @Nullable
    public String getStringValue() {
        return this.currentNode.isJsonPrimitive() ? (String)this.gson.fromJson(this.currentNode, String.class) : null;
    }

    @Nullable
    public Boolean getBooleanValue() {
        return this.currentNode.isJsonPrimitive() ? (Boolean)this.gson.fromJson(this.currentNode, Boolean.class) : null;
    }

    @Nullable
    public Byte getByteValue() {
        return this.currentNode.isJsonPrimitive() ? (Byte)this.gson.fromJson(this.currentNode, Byte.class) : null;
    }

    @Nullable
    public Short getShortValue() {
        return this.currentNode.isJsonPrimitive() ? (Short)this.gson.fromJson(this.currentNode, Short.class) : null;
    }

    @Nullable
    public BigDecimal getBigDecimalValue() {
        return this.currentNode.isJsonPrimitive() ? (BigDecimal)this.gson.fromJson(this.currentNode, BigDecimal.class) : null;
    }

    @Nullable
    public Integer getIntegerValue() {
        return this.currentNode.isJsonPrimitive() ? (Integer)this.gson.fromJson(this.currentNode, Integer.class) : null;
    }

    @Nullable
    public Float getFloatValue() {
        return this.currentNode.isJsonPrimitive() ? (Float)this.gson.fromJson(this.currentNode, Float.class) : null;
    }

    @Nullable
    public Double getDoubleValue() {
        return this.currentNode.isJsonPrimitive() ? (Double)this.gson.fromJson(this.currentNode, Double.class) : null;
    }

    @Nullable
    public Long getLongValue() {
        return this.currentNode.isJsonPrimitive() ? (Long)this.gson.fromJson(this.currentNode, Long.class) : null;
    }

    @Nullable
    public UUID getUUIDValue() {
        return (UUID)this.gson.fromJson(this.currentNode, UUID.class);
    }

    @Nullable
    public OffsetDateTime getOffsetDateTimeValue() {
        return (OffsetDateTime)this.gson.fromJson(this.currentNode, OffsetDateTime.class);
    }

    @Nullable
    public LocalDate getLocalDateValue() {
        return (LocalDate)this.gson.fromJson(this.currentNode, LocalDate.class);
    }

    @Nullable
    public LocalTime getLocalTimeValue() {
        return (LocalTime)this.gson.fromJson(this.currentNode, LocalTime.class);
    }

    @Nullable
    public PeriodAndDuration getPeriodAndDurationValue() {
        return (PeriodAndDuration)this.gson.fromJson(this.currentNode, PeriodAndDuration.class);
    }

    @Nullable
    private <T> T getPrimitiveValue(@Nonnull Class<T> targetClass, @Nonnull JsonParseNode itemNode) {
        return (T)this.gson.fromJson(itemNode.currentNode, targetClass);
    }

    private <T> List<T> iterateOnArray(JsonElement jsonElement, Function<JsonParseNode, T> fn) {
        JsonArray array = jsonElement.getAsJsonArray();
        Iterator sourceIterator = array.iterator();
        ArrayList<T> result = new ArrayList<T>();
        while (sourceIterator.hasNext()) {
            JsonElement item = (JsonElement)sourceIterator.next();
            JsonParseNode itemNode = this.createNewNode(item);
            itemNode.setOnBeforeAssignFieldValues(this.getOnBeforeAssignFieldValues());
            itemNode.setOnAfterAssignFieldValues(this.getOnAfterAssignFieldValues());
            result.add(fn.apply(itemNode));
        }
        return result;
    }

    @Nullable
    public <T> List<T> getCollectionOfPrimitiveValues(@Nonnull Class<T> targetClass) {
        Objects.requireNonNull(targetClass, "parameter targetClass cannot be null");
        if (this.currentNode.isJsonNull()) {
            return null;
        }
        if (this.currentNode.isJsonArray()) {
            return this.iterateOnArray(this.currentNode, itemNode -> this.getPrimitiveValue(targetClass, (JsonParseNode)itemNode));
        }
        throw new RuntimeException("invalid state expected to have an array node");
    }

    @Nullable
    public <T extends Parsable> List<T> getCollectionOfObjectValues(@Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(factory, "parameter factory cannot be null");
        if (this.currentNode.isJsonNull()) {
            return null;
        }
        if (this.currentNode.isJsonArray()) {
            return this.iterateOnArray(this.currentNode, itemNode -> itemNode.getObjectValue(factory));
        }
        return null;
    }

    @Nullable
    public <T extends Enum<T>> List<T> getCollectionOfEnumValues(@Nonnull ValuedEnumParser<T> enumParser) {
        Objects.requireNonNull(enumParser, "parameter enumParser cannot be null");
        if (this.currentNode.isJsonNull()) {
            return null;
        }
        if (this.currentNode.isJsonArray()) {
            return this.iterateOnArray(this.currentNode, itemNode -> itemNode.getEnumValue(enumParser));
        }
        throw new RuntimeException("invalid state expected to have an array node");
    }

    @Nonnull
    public <T extends Parsable> T getObjectValue(@Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(factory, "parameter factory cannot be null");
        Parsable item = factory.create((ParseNode)this);
        if (item.getClass() == UntypedNode.class) {
            return (T)this.getUntypedValue();
        }
        this.assignFieldValues(item, item.getFieldDeserializers());
        return (T)item;
    }

    @Nonnull
    private UntypedNode getUntypedValue() {
        return this.getUntypedValue(this.currentNode);
    }

    @Nonnull
    private UntypedNode getUntypedValue(JsonElement element) {
        if (element.isJsonNull()) {
            return new UntypedNull();
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return new UntypedBoolean(Boolean.valueOf(primitive.getAsBoolean()));
            }
            if (primitive.isString()) {
                return new UntypedString(primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return new UntypedDouble(Double.valueOf(primitive.getAsDouble()));
            }
            throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
        }
        if (element.isJsonObject()) {
            HashMap<String, UntypedNode> propertiesMap = new HashMap<String, UntypedNode>();
            for (Map.Entry fieldEntry : element.getAsJsonObject().entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                JsonElement fieldValue = (JsonElement)fieldEntry.getValue();
                JsonParseNode childNode = this.createNewNode(fieldValue);
                childNode.setOnBeforeAssignFieldValues(this.getOnBeforeAssignFieldValues());
                childNode.setOnAfterAssignFieldValues(this.getOnAfterAssignFieldValues());
                propertiesMap.put(fieldKey, childNode.getUntypedValue());
            }
            return new UntypedObject(propertiesMap);
        }
        if (element.isJsonArray()) {
            return new UntypedArray(this.iterateOnArray(element, JsonParseNode::getUntypedValue));
        }
        throw new RuntimeException("Could not get the value during deserialization, unknown json value type");
    }

    @Nullable
    public <T extends Enum<T>> T getEnumValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        return (T)enumParser.forValue(rawValue);
    }

    @Nullable
    public <T extends Enum<T>> EnumSet<T> getEnumSetValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String[] rawValues;
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        ArrayList<Enum> result = new ArrayList<Enum>();
        for (String rawValueItem : rawValues = rawValue.split(",")) {
            Enum value = enumParser.forValue(rawValueItem);
            if (value == null) continue;
            result.add(value);
        }
        return EnumSet.copyOf(result);
    }

    private <T extends Parsable> void assignFieldValues(T item, Map<String, Consumer<ParseNode>> fieldDeserializers) {
        if (this.currentNode.isJsonObject()) {
            if (this.onBeforeAssignFieldValues != null) {
                this.onBeforeAssignFieldValues.accept(item);
            }
            Map itemAdditionalData = null;
            if (item instanceof AdditionalDataHolder) {
                itemAdditionalData = ((AdditionalDataHolder)item).getAdditionalData();
            }
            for (Map.Entry fieldEntry : this.currentNode.getAsJsonObject().entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                Consumer<ParseNode> fieldDeserializer = fieldDeserializers.get(fieldKey);
                JsonElement fieldValue = (JsonElement)fieldEntry.getValue();
                if (fieldValue.isJsonNull()) continue;
                if (fieldDeserializer != null) {
                    JsonParseNode itemNode = this.createNewNode(fieldValue);
                    itemNode.setOnBeforeAssignFieldValues(this.onBeforeAssignFieldValues);
                    itemNode.setOnAfterAssignFieldValues(this.onAfterAssignFieldValues);
                    fieldDeserializer.accept(itemNode);
                    continue;
                }
                if (itemAdditionalData == null) continue;
                itemAdditionalData.put(fieldKey, this.tryGetAnything(fieldValue));
            }
            if (this.onAfterAssignFieldValues != null) {
                this.onAfterAssignFieldValues.accept(item);
            }
        }
    }

    private Object tryGetAnything(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
        }
        if (element.isJsonObject() || element.isJsonArray()) {
            return this.getUntypedValue(element);
        }
        throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
    }

    @Nullable
    public Consumer<Parsable> getOnBeforeAssignFieldValues() {
        return this.onBeforeAssignFieldValues;
    }

    @Nullable
    public Consumer<Parsable> getOnAfterAssignFieldValues() {
        return this.onAfterAssignFieldValues;
    }

    public void setOnBeforeAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onBeforeAssignFieldValues = value;
    }

    public void setOnAfterAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onAfterAssignFieldValues = value;
    }

    @Nullable
    public byte[] getByteArrayValue() {
        return this.currentNode.isJsonPrimitive() ? (byte[])this.gson.fromJson(this.currentNode, byte[].class) : null;
    }
}

