/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.MockMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class MockBytesMessage
extends MockMessage
implements BytesMessage {
    private DataOutputStream outStream;
    private ByteArrayOutputStream byteOutStream;
    private DataInputStream inStream;

    public MockBytesMessage() {
        try {
            this.clearBody();
        }
        catch (JMSException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public long getBodyLength() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        return this.outStream.size();
    }

    public boolean readBoolean() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readBoolean();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public byte readByte() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readByte();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public int readUnsignedByte() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readByte();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public short readShort() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readShort();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public int readUnsignedShort() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readShort();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public char readChar() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readChar();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public int readInt() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readInt();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public long readLong() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readLong();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public float readFloat() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readFloat();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public double readDouble() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readDouble();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public String readUTF() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readUTF();
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public int readBytes(byte[] data) throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.read(data);
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public int readBytes(byte[] data, int length) throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.read(data, 0, length);
        }
        catch (EOFException exc) {
            throw new MessageEOFException(exc.getMessage());
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeBoolean(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeByte(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeShort(short value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeShort(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeChar(char value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeChar(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeInt(int value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeInt(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeLong(long value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeLong(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeFloat(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeDouble(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeUTF(String value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeUTF(value);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeBytes(byte[] data) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.write(data);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeBytes(byte[] data, int offset, int length) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.write(data, offset, length);
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (object instanceof Byte) {
            this.writeByte((Byte)object);
            return;
        }
        if (object instanceof Short) {
            this.writeShort((Short)object);
            return;
        }
        if (object instanceof Integer) {
            this.writeInt((Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.writeLong((Long)object);
            return;
        }
        if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.writeDouble((Double)object);
            return;
        }
        if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
            return;
        }
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
            return;
        }
        if (object instanceof String) {
            this.writeUTF((String)object);
            return;
        }
        if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
            return;
        }
        throw new MessageFormatException(object.getClass().getName() + " is an invalid type");
    }

    public void reset() throws JMSException {
        this.setReadOnly(true);
        try {
            this.outStream.flush();
        }
        catch (IOException exc) {
            throw new JMSException(exc.getMessage());
        }
        this.inStream = new DataInputStream(new ByteArrayInputStream(this.byteOutStream.toByteArray()));
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.byteOutStream = new ByteArrayOutputStream();
        this.outStream = new DataOutputStream(this.byteOutStream);
    }

    public byte[] getBytes() {
        try {
            this.outStream.flush();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc.getMessage());
        }
        return this.byteOutStream.toByteArray();
    }

    public boolean equals(Object otherObject) {
        if (null == otherObject) {
            return false;
        }
        if (!(otherObject instanceof MockBytesMessage)) {
            return false;
        }
        MockBytesMessage otherMessage = (MockBytesMessage)otherObject;
        byte[] firstData = this.getBytes();
        byte[] secondData = otherMessage.getBytes();
        return Arrays.equals(firstData, secondData);
    }

    public int hashCode() {
        byte[] data;
        int value = 17;
        for (byte aData : data = this.getBytes()) {
            value = 31 * value + aData;
        }
        return value;
    }

    @Override
    public Object clone() {
        MockBytesMessage message = (MockBytesMessage)super.clone();
        try {
            message.clearBody();
            message.outStream.write(this.getBytes());
            return message;
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName()).append(": [");
        byte[] data = this.getBytes();
        for (int ii = 0; ii < data.length; ++ii) {
            buffer.append(data[ii]);
            if (ii >= data.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

